/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/cpm_ts103324/asn/CPM-PDU-Descriptions.asn \
  asn1/raw/cpm_ts103324/asn/CPM-OriginatingStationContainers.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceivedObjectContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceptionRegionContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-SensorInformationContainer.asn \
  asn1/patched/cpm_ts103324/asn/cdd/ETSI-ITS-CDD.asn \
  -t \
  cpm_ts \
  -o \
  etsi_its_conversion/etsi_its_cpm_ts_conversion/include/etsi_its_cpm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF represents a unique id for an intersection, in accordance with ETSI TS 103 301 [15].
 *
 * It shall include the following components: 
 *
 * @field region: the optional identifier of the entity that is responsible for the region in which the intersection is placed.
 * It is the duty of that entity to guarantee that the @ref Id is unique within the region.
 *
 * @field id: the identifier of the intersection
 *
 * @note: when the component region is present, the IntersectionReferenceId is guaranteed to be globally unique.
 * @category: Road topology information
 * @revision: created in V2.1.1
 *
IntersectionReferenceId ::= SEQUENCE {
    region    Identifier2B OPTIONAL,
    id        Identifier2B
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_cpm_ts_coding/cpm_ts_IntersectionReferenceId.h>
#include <etsi_its_cpm_ts_conversion/convertIdentifier2B.h>
#ifdef ROS1
#include <etsi_its_cpm_ts_msgs/IntersectionReferenceId.h>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs;
#else
#include <etsi_its_cpm_ts_msgs/msg/intersection_reference_id.hpp>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs::msg;
#endif


namespace etsi_its_cpm_ts_conversion {

void toRos_IntersectionReferenceId(const cpm_ts_IntersectionReferenceId_t& in, cpm_ts_msgs::IntersectionReferenceId& out) {
  if (in.region) {
    toRos_Identifier2B(*in.region, out.region);
    out.region_is_present = true;
  }
  toRos_Identifier2B(in.id, out.id);
}

void toStruct_IntersectionReferenceId(const cpm_ts_msgs::IntersectionReferenceId& in, cpm_ts_IntersectionReferenceId_t& out) {
  memset(&out, 0, sizeof(cpm_ts_IntersectionReferenceId_t));
  if (in.region_is_present) {
    out.region = (cpm_ts_Identifier2B_t*) calloc(1, sizeof(cpm_ts_Identifier2B_t));
    toStruct_Identifier2B(in.region, *out.region);
  }
  toStruct_Identifier2B(in.id, out.id);
}

}
