/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/cpm_ts103324/asn/CPM-PDU-Descriptions.asn \
  asn1/raw/cpm_ts103324/asn/CPM-OriginatingStationContainers.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceivedObjectContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceptionRegionContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-SensorInformationContainer.asn \
  asn1/patched/cpm_ts103324/asn/cdd/ETSI-ITS-CDD.asn \
  -t \
  cpm_ts \
  -o \
  etsi_its_conversion/etsi_its_cpm_ts_conversion/include/etsi_its_cpm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DF represents a lower triangular positive semi-definite matrix. 
 *
 * It shall include the following components: 
 *
 * @field componentsIncludedIntheMatrix: the indication of which components of a @ref PerceivedObject are included in the matrix. 
 * This component also implicitly indicates the number n of included components which defines the size (n x n) of the full correlation matrix "A".
 *
 * @field matrix: the list of cells of the lower triangular positive semi-definite matrix ordered by columns and by rows. 
 *
 * The number of columns to be included "k" is equal to the number of included components "n" indicated by componentsIncludedIntheMatrix minus 1: k = n-1.
 * These components shall be included in the order or their appearance in componentsIncludedIntheMatrix.
 * Each column "i" of the lowerTriangularCorrelationMatrixColumns contains k-(i-1) values.
 *
 * @category: Sensing information
 * @revision: Created in V2.1.1
*
LowerTriangularPositiveSemidefiniteMatrix ::= SEQUENCE{
    componentsIncludedIntheMatrix   MatrixIncludedComponents,
    matrix                          LowerTriangularPositiveSemidefiniteMatrixColumns
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_cpm_ts_coding/cpm_ts_LowerTriangularPositiveSemidefiniteMatrix.h>
#include <etsi_its_cpm_ts_conversion/convertLowerTriangularPositiveSemidefiniteMatrixColumns.h>
#include <etsi_its_cpm_ts_conversion/convertMatrixIncludedComponents.h>
#ifdef ROS1
#include <etsi_its_cpm_ts_msgs/LowerTriangularPositiveSemidefiniteMatrix.h>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs;
#else
#include <etsi_its_cpm_ts_msgs/msg/lower_triangular_positive_semidefinite_matrix.hpp>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs::msg;
#endif


namespace etsi_its_cpm_ts_conversion {

void toRos_LowerTriangularPositiveSemidefiniteMatrix(const cpm_ts_LowerTriangularPositiveSemidefiniteMatrix_t& in, cpm_ts_msgs::LowerTriangularPositiveSemidefiniteMatrix& out) {
  toRos_MatrixIncludedComponents(in.componentsIncludedIntheMatrix, out.components_included_inthe_matrix);
  toRos_LowerTriangularPositiveSemidefiniteMatrixColumns(in.matrix, out.matrix);
}

void toStruct_LowerTriangularPositiveSemidefiniteMatrix(const cpm_ts_msgs::LowerTriangularPositiveSemidefiniteMatrix& in, cpm_ts_LowerTriangularPositiveSemidefiniteMatrix_t& out) {
  memset(&out, 0, sizeof(cpm_ts_LowerTriangularPositiveSemidefiniteMatrix_t));
  toStruct_MatrixIncludedComponents(in.components_included_inthe_matrix, out.componentsIncludedIntheMatrix);
  toStruct_LowerTriangularPositiveSemidefiniteMatrixColumns(in.matrix, out.matrix);
}

}
