/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/cpm_ts103324/asn/CPM-PDU-Descriptions.asn \
  asn1/raw/cpm_ts103324/asn/CPM-OriginatingStationContainers.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceivedObjectContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceptionRegionContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-SensorInformationContainer.asn \
  asn1/patched/cpm_ts103324/asn/cdd/ETSI-ITS-CDD.asn \
  -t \
  cpm_ts \
  -o \
  etsi_its_conversion/etsi_its_cpm_ts_conversion/include/etsi_its_cpm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF  represents the management container of the CPM. 
 * The management container provides basic information about the originating ITS-S, which are not specific to a specific type of station.
 *
 * It shall include the following components: 
 *
 * @field referenceTime: the reference time for all time related information in the CPM.
 *
 * @field messageRateRange: the planned or expected range of the CPM generation rate.
 *
 * @field segmentationInfo: information regarding the message segmentation on facility layer.
 *
 * @field referencePosition: the reference position for all position related information in the CPM.
 *
*
ManagementContainer ::= SEQUENCE {
    referenceTime      TimestampIts,
    referencePosition  ReferencePosition,
    segmentationInfo   MessageSegmentationInfo OPTIONAL,
    messageRateRange   MessageRateRange OPTIONAL,
    ...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_cpm_ts_coding/cpm_ts_ManagementContainer.h>
#include <etsi_its_cpm_ts_conversion/convertMessageRateRange.h>
#include <etsi_its_cpm_ts_conversion/convertMessageSegmentationInfo.h>
#include <etsi_its_cpm_ts_conversion/convertReferencePosition.h>
#include <etsi_its_cpm_ts_conversion/convertTimestampIts.h>
#ifdef ROS1
#include <etsi_its_cpm_ts_msgs/ManagementContainer.h>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs;
#else
#include <etsi_its_cpm_ts_msgs/msg/management_container.hpp>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs::msg;
#endif


namespace etsi_its_cpm_ts_conversion {

void toRos_ManagementContainer(const cpm_ts_ManagementContainer_t& in, cpm_ts_msgs::ManagementContainer& out) {
  toRos_TimestampIts(in.referenceTime, out.reference_time);
  toRos_ReferencePosition(in.referencePosition, out.reference_position);
  if (in.segmentationInfo) {
    toRos_MessageSegmentationInfo(*in.segmentationInfo, out.segmentation_info);
    out.segmentation_info_is_present = true;
  }
  if (in.messageRateRange) {
    toRos_MessageRateRange(*in.messageRateRange, out.message_rate_range);
    out.message_rate_range_is_present = true;
  }
}

void toStruct_ManagementContainer(const cpm_ts_msgs::ManagementContainer& in, cpm_ts_ManagementContainer_t& out) {
  memset(&out, 0, sizeof(cpm_ts_ManagementContainer_t));
  toStruct_TimestampIts(in.reference_time, out.referenceTime);
  toStruct_ReferencePosition(in.reference_position, out.referencePosition);
  if (in.segmentation_info_is_present) {
    out.segmentationInfo = (cpm_ts_MessageSegmentationInfo_t*) calloc(1, sizeof(cpm_ts_MessageSegmentationInfo_t));
    toStruct_MessageSegmentationInfo(in.segmentation_info, *out.segmentationInfo);
  }
  if (in.message_rate_range_is_present) {
    out.messageRateRange = (cpm_ts_MessageRateRange_t*) calloc(1, sizeof(cpm_ts_MessageRateRange_t));
    toStruct_MessageRateRange(in.message_rate_range, *out.messageRateRange);
  }
}

}
