/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/cpm_ts103324/asn/CPM-PDU-Descriptions.asn \
  asn1/raw/cpm_ts103324/asn/CPM-OriginatingStationContainers.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceivedObjectContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceptionRegionContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-SensorInformationContainer.asn \
  asn1/patched/cpm_ts103324/asn/cdd/ETSI-ITS-CDD.asn \
  -t \
  cpm_ts \
  -o \
  etsi_its_conversion/etsi_its_cpm_ts_conversion/include/etsi_its_cpm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF indicates a position on a topology description transmitted in a MAPEM according to ETSI TS 103 301 [15].
 *
 * It shall include the following components: 
 * 
 * @field mapReference: optionally identifies the MAPEM containing the topology information.
 * It is absent if the MAPEM topology is known from the context.
 * 
 * @field laneId: optionally identifies the lane in the road segment or intersection topology on which the position is located.
 *
 * @field connectionId: optionally identifies the connection inside the conflict area of an intersection, i.e. it identifies a trajectory for travelling through the
 * conflict area of an intersection which connects e.g an ingress with an egress lane.
 *
 * @field longitudinalLanePosition: optionally indicates the longitudinal offset of the map-matched position of the object along the lane or connection.
 * 
 * @category: Road topology information
 * @revision: Created in V2.1.1
 *
MapPosition ::= SEQUENCE {
    mapReference                MapReference OPTIONAL,
    laneId                      Identifier1B OPTIONAL,
    connectionId                Identifier1B OPTIONAL, 
    longitudinalLanePosition    LongitudinalLanePosition OPTIONAL,
    ...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_cpm_ts_coding/cpm_ts_MapPosition.h>
#include <etsi_its_cpm_ts_conversion/convertIdentifier1B.h>
#include <etsi_its_cpm_ts_conversion/convertLongitudinalLanePosition.h>
#include <etsi_its_cpm_ts_conversion/convertMapReference.h>
#ifdef ROS1
#include <etsi_its_cpm_ts_msgs/MapPosition.h>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs;
#else
#include <etsi_its_cpm_ts_msgs/msg/map_position.hpp>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs::msg;
#endif


namespace etsi_its_cpm_ts_conversion {

void toRos_MapPosition(const cpm_ts_MapPosition_t& in, cpm_ts_msgs::MapPosition& out) {
  if (in.mapReference) {
    toRos_MapReference(*in.mapReference, out.map_reference);
    out.map_reference_is_present = true;
  }
  if (in.laneId) {
    toRos_Identifier1B(*in.laneId, out.lane_id);
    out.lane_id_is_present = true;
  }
  if (in.connectionId) {
    toRos_Identifier1B(*in.connectionId, out.connection_id);
    out.connection_id_is_present = true;
  }
  if (in.longitudinalLanePosition) {
    toRos_LongitudinalLanePosition(*in.longitudinalLanePosition, out.longitudinal_lane_position);
    out.longitudinal_lane_position_is_present = true;
  }
}

void toStruct_MapPosition(const cpm_ts_msgs::MapPosition& in, cpm_ts_MapPosition_t& out) {
  memset(&out, 0, sizeof(cpm_ts_MapPosition_t));
  if (in.map_reference_is_present) {
    out.mapReference = (cpm_ts_MapReference_t*) calloc(1, sizeof(cpm_ts_MapReference_t));
    toStruct_MapReference(in.map_reference, *out.mapReference);
  }
  if (in.lane_id_is_present) {
    out.laneId = (cpm_ts_Identifier1B_t*) calloc(1, sizeof(cpm_ts_Identifier1B_t));
    toStruct_Identifier1B(in.lane_id, *out.laneId);
  }
  if (in.connection_id_is_present) {
    out.connectionId = (cpm_ts_Identifier1B_t*) calloc(1, sizeof(cpm_ts_Identifier1B_t));
    toStruct_Identifier1B(in.connection_id, *out.connectionId);
  }
  if (in.longitudinal_lane_position_is_present) {
    out.longitudinalLanePosition = (cpm_ts_LongitudinalLanePosition_t*) calloc(1, sizeof(cpm_ts_LongitudinalLanePosition_t));
    toStruct_LongitudinalLanePosition(in.longitudinal_lane_position, *out.longitudinalLanePosition);
  }
}

}
