/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/cpm_ts103324/asn/CPM-PDU-Descriptions.asn \
  asn1/raw/cpm_ts103324/asn/CPM-OriginatingStationContainers.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceivedObjectContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceptionRegionContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-SensorInformationContainer.asn \
  asn1/patched/cpm_ts103324/asn/cdd/ETSI-ITS-CDD.asn \
  -t \
  cpm_ts \
  -o \
  etsi_its_conversion/etsi_its_cpm_ts_conversion/include/etsi_its_cpm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF represents the actual perception capabilities available to the transmitting ITS-S, offering additional (often dynamic) details to the information provided in the sensor information container.
 *
 * It shall include the following components: 

 * @field measurementDeltaTime: difference between the time of estimation of the perception region and the reference time. Positive values indicates that the provided information refers to a point in time after the reference time.
 *
 * @field perceptionRegionConfidence: the perception confidence.
 *
 * @field perceptionRegionShape: specification of the shape of the perception region.
 *
 * @field shadowingApplies: indicates if the standard shadowing approach applies to the described perception region.
 *
 * @field sensorIdList: the optional list of identifiers of the sensors which are involved in perceiving the region.
 *
 * @field numberOfPerceivedObjects: the optional number of perceived objects contained in the perception region specified in the component perceptionRegionShape. 
 *
 * @field perceivedObjectIds: the optional list of identifiers of the objects specified in the Perceived Object Container that are contained in the perception region specified in the component perceptionRegionShape.
 *
*
PerceptionRegion ::= SEQUENCE {
    measurementDeltaTime         DeltaTimeMilliSecondSigned,     
    perceptionRegionConfidence   ConfidenceLevel,
    perceptionRegionShape        Shape, 
    shadowingApplies             BOOLEAN,
    sensorIdList                 SequenceOfIdentifier1B OPTIONAL,
    numberOfPerceivedObjects     CardinalNumber1B OPTIONAL,
    perceivedObjectIds           PerceivedObjectIds OPTIONAL,
	...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_cpm_ts_coding/cpm_ts_PerceptionRegion.h>
#include <etsi_its_cpm_ts_coding/BOOLEAN.h>
#include <etsi_its_primitives_conversion/convertBOOLEAN.h>
#include <etsi_its_cpm_ts_conversion/convertCardinalNumber1B.h>
#include <etsi_its_cpm_ts_conversion/convertConfidenceLevel.h>
#include <etsi_its_cpm_ts_conversion/convertDeltaTimeMilliSecondSigned.h>
#include <etsi_its_cpm_ts_conversion/convertPerceivedObjectIds.h>
#include <etsi_its_cpm_ts_conversion/convertSequenceOfIdentifier1B.h>
#include <etsi_its_cpm_ts_conversion/convertShape.h>
#ifdef ROS1
#include <etsi_its_cpm_ts_msgs/PerceptionRegion.h>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs;
#else
#include <etsi_its_cpm_ts_msgs/msg/perception_region.hpp>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs::msg;
#endif


namespace etsi_its_cpm_ts_conversion {

void toRos_PerceptionRegion(const cpm_ts_PerceptionRegion_t& in, cpm_ts_msgs::PerceptionRegion& out) {
  toRos_DeltaTimeMilliSecondSigned(in.measurementDeltaTime, out.measurement_delta_time);
  toRos_ConfidenceLevel(in.perceptionRegionConfidence, out.perception_region_confidence);
  toRos_Shape(in.perceptionRegionShape, out.perception_region_shape);
  etsi_its_primitives_conversion::toRos_BOOLEAN(in.shadowingApplies, out.shadowing_applies);
  if (in.sensorIdList) {
    toRos_SequenceOfIdentifier1B(*in.sensorIdList, out.sensor_id_list);
    out.sensor_id_list_is_present = true;
  }
  if (in.numberOfPerceivedObjects) {
    toRos_CardinalNumber1B(*in.numberOfPerceivedObjects, out.number_of_perceived_objects);
    out.number_of_perceived_objects_is_present = true;
  }
  if (in.perceivedObjectIds) {
    toRos_PerceivedObjectIds(*in.perceivedObjectIds, out.perceived_object_ids);
    out.perceived_object_ids_is_present = true;
  }
}

void toStruct_PerceptionRegion(const cpm_ts_msgs::PerceptionRegion& in, cpm_ts_PerceptionRegion_t& out) {
  memset(&out, 0, sizeof(cpm_ts_PerceptionRegion_t));
  toStruct_DeltaTimeMilliSecondSigned(in.measurement_delta_time, out.measurementDeltaTime);
  toStruct_ConfidenceLevel(in.perception_region_confidence, out.perceptionRegionConfidence);
  toStruct_Shape(in.perception_region_shape, out.perceptionRegionShape);
  etsi_its_primitives_conversion::toStruct_BOOLEAN(in.shadowing_applies, out.shadowingApplies);
  if (in.sensor_id_list_is_present) {
    out.sensorIdList = (cpm_ts_SequenceOfIdentifier1B_t*) calloc(1, sizeof(cpm_ts_SequenceOfIdentifier1B_t));
    toStruct_SequenceOfIdentifier1B(in.sensor_id_list, *out.sensorIdList);
  }
  if (in.number_of_perceived_objects_is_present) {
    out.numberOfPerceivedObjects = (cpm_ts_CardinalNumber1B_t*) calloc(1, sizeof(cpm_ts_CardinalNumber1B_t));
    toStruct_CardinalNumber1B(in.number_of_perceived_objects, *out.numberOfPerceivedObjects);
  }
  if (in.perceived_object_ids_is_present) {
    out.perceivedObjectIds = (cpm_ts_PerceivedObjectIds_t*) calloc(1, sizeof(cpm_ts_PerceivedObjectIds_t));
    toStruct_PerceivedObjectIds(in.perceived_object_ids, *out.perceivedObjectIds);
  }
}

}
