/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/cpm_ts103324/asn/CPM-PDU-Descriptions.asn \
  asn1/raw/cpm_ts103324/asn/CPM-OriginatingStationContainers.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceivedObjectContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceptionRegionContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-SensorInformationContainer.asn \
  asn1/patched/cpm_ts103324/asn/cdd/ETSI-ITS-CDD.asn \
  -t \
  cpm_ts \
  -o \
  etsi_its_conversion/etsi_its_cpm_ts_conversion/include/etsi_its_cpm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DF represents the shape of a polygonal area or of a right prism.
 *
 * It shall include the following components: 
 *
 * @field shapeReferencePoint: the optional reference point used for the definition of the shape, relative to an externally specified reference position. 
 * If this component is absent, the externally specified reference position represents the shape's reference point. 
 *
 * @field polygon: the polygonal area represented by a list of minimum `3` to maximum `16` @ref CartesianPosition3d.
 * All nodes of the polygon shall be considered relative to the shape's reference point.
 *
 * @field height: the optional height, present if the shape is a right prism extending in the positive z-axis.
 * 
 * @category GeoReference information
 * @revision: created in V2.1.1
 *
 *
PolygonalShape ::= SEQUENCE {
   shapeReferencePoint    CartesianPosition3d OPTIONAL,
   polygon                SequenceOfCartesianPosition3d (SIZE(3..16,...)),
   height                 StandardLength12b OPTIONAL
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_cpm_ts_coding/cpm_ts_PolygonalShape.h>
#include <etsi_its_cpm_ts_conversion/convertCartesianPosition3d.h>
#include <etsi_its_cpm_ts_conversion/convertSequenceOfCartesianPosition3d.h>
#include <etsi_its_cpm_ts_conversion/convertStandardLength12b.h>
#ifdef ROS1
#include <etsi_its_cpm_ts_msgs/PolygonalShape.h>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs;
#else
#include <etsi_its_cpm_ts_msgs/msg/polygonal_shape.hpp>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs::msg;
#endif


namespace etsi_its_cpm_ts_conversion {

void toRos_PolygonalShape(const cpm_ts_PolygonalShape_t& in, cpm_ts_msgs::PolygonalShape& out) {
  if (in.shapeReferencePoint) {
    toRos_CartesianPosition3d(*in.shapeReferencePoint, out.shape_reference_point);
    out.shape_reference_point_is_present = true;
  }
  toRos_SequenceOfCartesianPosition3d(in.polygon, out.polygon);
  if (in.height) {
    toRos_StandardLength12b(*in.height, out.height);
    out.height_is_present = true;
  }
}

void toStruct_PolygonalShape(const cpm_ts_msgs::PolygonalShape& in, cpm_ts_PolygonalShape_t& out) {
  memset(&out, 0, sizeof(cpm_ts_PolygonalShape_t));
  if (in.shape_reference_point_is_present) {
    out.shapeReferencePoint = (cpm_ts_CartesianPosition3d_t*) calloc(1, sizeof(cpm_ts_CartesianPosition3d_t));
    toStruct_CartesianPosition3d(in.shape_reference_point, *out.shapeReferencePoint);
  }
  toStruct_SequenceOfCartesianPosition3d(in.polygon, out.polygon);
  if (in.height_is_present) {
    out.height = (cpm_ts_StandardLength12b_t*) calloc(1, sizeof(cpm_ts_StandardLength12b_t));
    toStruct_StandardLength12b(in.height, *out.height);
  }
}

}
