/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/cpm_ts103324/asn/CPM-PDU-Descriptions.asn \
  asn1/raw/cpm_ts103324/asn/CPM-OriginatingStationContainers.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceivedObjectContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceptionRegionContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-SensorInformationContainer.asn \
  asn1/patched/cpm_ts103324/asn/cdd/ETSI-ITS-CDD.asn \
  -t \
  cpm_ts \
  -o \
  etsi_its_conversion/etsi_its_cpm_ts_conversion/include/etsi_its_cpm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DF represents the shape of a rectangular area or a right rectangular prism that is centred on a reference position defined outside of the context of this DF. 
 *
 * It shall include the following components: 
 * 
 * @field centerPoint: represents an optional offset point which the rectangle is centred on with respect to the reference position.
 *
 * @field semiLength: represents half the length of the rectangle.
 * 
 * @field semiBreadth: represents half the breadth of the rectangle.
 *
 * @field orientation: represents the optional orientation of the lenght of the rectangle in the WGS84 coordinate system.
 * The specific WGS84 coordinate system is specified by the corresponding standards applying this DE.
 *
 * @field height: represents the optional height, present if the shape is a right rectangular prism with height extending in the positive z-axis.
 *
 * @category GeoReference information
 * @revision: created in V2.1.1
 *
RectangularShape ::= SEQUENCE { 
    centerPoint    CartesianPosition3d OPTIONAL,
    semiLength     StandardLength12b,
    semiBreadth    StandardLength12b,
    orientation    Wgs84AngleValue OPTIONAL,
    height         StandardLength12b OPTIONAL
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_cpm_ts_coding/cpm_ts_RectangularShape.h>
#include <etsi_its_cpm_ts_conversion/convertCartesianPosition3d.h>
#include <etsi_its_cpm_ts_conversion/convertStandardLength12b.h>
#include <etsi_its_cpm_ts_conversion/convertWgs84AngleValue.h>
#ifdef ROS1
#include <etsi_its_cpm_ts_msgs/RectangularShape.h>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs;
#else
#include <etsi_its_cpm_ts_msgs/msg/rectangular_shape.hpp>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs::msg;
#endif


namespace etsi_its_cpm_ts_conversion {

void toRos_RectangularShape(const cpm_ts_RectangularShape_t& in, cpm_ts_msgs::RectangularShape& out) {
  if (in.centerPoint) {
    toRos_CartesianPosition3d(*in.centerPoint, out.center_point);
    out.center_point_is_present = true;
  }
  toRos_StandardLength12b(in.semiLength, out.semi_length);
  toRos_StandardLength12b(in.semiBreadth, out.semi_breadth);
  if (in.orientation) {
    toRos_Wgs84AngleValue(*in.orientation, out.orientation);
    out.orientation_is_present = true;
  }
  if (in.height) {
    toRos_StandardLength12b(*in.height, out.height);
    out.height_is_present = true;
  }
}

void toStruct_RectangularShape(const cpm_ts_msgs::RectangularShape& in, cpm_ts_RectangularShape_t& out) {
  memset(&out, 0, sizeof(cpm_ts_RectangularShape_t));
  if (in.center_point_is_present) {
    out.centerPoint = (cpm_ts_CartesianPosition3d_t*) calloc(1, sizeof(cpm_ts_CartesianPosition3d_t));
    toStruct_CartesianPosition3d(in.center_point, *out.centerPoint);
  }
  toStruct_StandardLength12b(in.semi_length, out.semiLength);
  toStruct_StandardLength12b(in.semi_breadth, out.semiBreadth);
  if (in.orientation_is_present) {
    out.orientation = (cpm_ts_Wgs84AngleValue_t*) calloc(1, sizeof(cpm_ts_Wgs84AngleValue_t));
    toStruct_Wgs84AngleValue(in.orientation, *out.orientation);
  }
  if (in.height_is_present) {
    out.height = (cpm_ts_StandardLength12b_t*) calloc(1, sizeof(cpm_ts_StandardLength12b_t));
    toStruct_StandardLength12b(in.height, *out.height);
  }
}

}
