/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/cpm_ts103324/asn/CPM-PDU-Descriptions.asn \
  asn1/raw/cpm_ts103324/asn/CPM-OriginatingStationContainers.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceivedObjectContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceptionRegionContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-SensorInformationContainer.asn \
  asn1/patched/cpm_ts103324/asn/cdd/ETSI-ITS-CDD.asn \
  -t \
  cpm_ts \
  -o \
  etsi_its_conversion/etsi_its_cpm_ts_conversion/include/etsi_its_cpm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DE indicates the type of sensor.
 * 
 * The value shall be set to:
 * - 0  `undefined`         - in case the sensor type is undefined. 
 * - 1  `radar`             - in case the sensor is a radar,
 * - 2  `lidar`             - in case the sensor is a lidar,
 * - 3  `monovideo`         - in case the sensor is mono video,
 * - 4  `stereovision`      - in case the sensor is stereo vision,
 * - 5  `nightvision`       - in case the sensor is night vision,
 * - 6  `ultrasonic`        - in case the sensor is ultrasonic,
 * - 7  `pmd`               - in case the sensor is photonic mixing device,
 * - 8  `inductionLoop`     - in case the sensor is an induction loop,
 * - 9  `sphericalCamera`   - in case the sensor is a spherical camera,
 * - 10 `uwb`               - in case the sensor is ultra wide band,
 * - 11 `acoustic`          - in case the sensor is acoustic,
 * - 12 `localAggregation`  - in case the information is provided by a system that aggregates information from different local sensors. Aggregation may include fusion,
 * - 13 `itsAggregation`    - in case the information is provided by a system that aggregates information from other received ITS messages.
 * - 14-31                  - are reserved for future usage.
 *
 * @category: Sensing Information
 * @revision: created in V2.1.1
*
SensorType ::= INTEGER {
    undefined         (0),
    radar             (1),
    lidar             (2),
    monovideo         (3),
    stereovision      (4),
    nightvision       (5),
    ultrasonic        (6),
    pmd               (7),
    inductionLoop     (8),
    sphericalCamera   (9),
    uwb               (10),
    acoustic          (11),
    localAggregation  (12),
    itsAggregation    (13)
} (0..31)
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_cpm_ts_coding/cpm_ts_SensorType.h>
#include <etsi_its_cpm_ts_coding/INTEGER.h>
#include <etsi_its_primitives_conversion/convertINTEGER.h>
#ifdef ROS1
#include <etsi_its_cpm_ts_msgs/SensorType.h>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs;
#else
#include <etsi_its_cpm_ts_msgs/msg/sensor_type.hpp>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs::msg;
#endif


namespace etsi_its_cpm_ts_conversion {

void toRos_SensorType(const cpm_ts_SensorType_t& in, cpm_ts_msgs::SensorType& out) {
  etsi_its_primitives_conversion::toRos_INTEGER(in, out.value);
}

void toStruct_SensorType(const cpm_ts_msgs::SensorType& in, cpm_ts_SensorType_t& out) {
  memset(&out, 0, sizeof(cpm_ts_SensorType_t));
  etsi_its_primitives_conversion::toStruct_INTEGER(in.value, out);
}

}
