/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/cpm_ts103324/asn/CPM-PDU-Descriptions.asn \
  asn1/raw/cpm_ts103324/asn/CPM-OriginatingStationContainers.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceivedObjectContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-PerceptionRegionContainer.asn \
  asn1/raw/cpm_ts103324/asn/CPM-SensorInformationContainer.asn \
  asn1/patched/cpm_ts103324/asn/cdd/ETSI-ITS-CDD.asn \
  -t \
  cpm_ts \
  -o \
  etsi_its_conversion/etsi_its_cpm_ts_conversion/include/etsi_its_cpm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DF provides detailed information about an attached trailer.
 *
 * It shall include the following components: 
 *
 * @field refPointId: identifier of the reference point of the trailer.
 *
 * @field hitchPointOffset: optional position of the hitch point in negative x-direction (according to ISO 8855) from the
 * vehicle Reference Point.
 *
 * @field frontOverhang: optional length of the trailer overhang in the positive x direction (according to ISO 8855) from the
 * trailer Reference Point indicated by the refPointID. The value defaults to 0 in case the trailer
 * is not overhanging to the front with respect to the trailer reference point.
 *
 * @field rearOverhang: optional length of the trailer overhang in the negative x direction (according to ISO 8855) from the
 * trailer Reference Point indicated by the refPointID.
 *
 * @field trailerWidth: optional width of the trailer.
 *
 * @field hitchAngle: optional Value and confidence value of the angle between the trailer orientation (corresponding to the x
 * direction of the ISO 8855 [21] coordinate system centered on the trailer) and the direction of
 * the segment having as end points the reference point of the trailer and the reference point of
 * the pulling vehicle, which can be another trailer or a vehicle looking on the horizontal plane
 * xy, described in the local Cartesian coordinate system of the trailer. The
 * angle is measured with negative values considering the trailer orientation turning clockwise
 * starting from the segment direction. The angle value accuracy is provided with the
 * confidence level of 95 %.
 *
 * @category: Vehicle information
 * @revision: Created in V2.1.1
*
TrailerData ::= SEQUENCE { 
    refPointId          Identifier1B,
    hitchPointOffset    StandardLength1B, 
    frontOverhang       StandardLength1B OPTIONAL, 
    rearOverhang        StandardLength1B OPTIONAL, 
    trailerWidth        VehicleWidth OPTIONAL,
    hitchAngle          CartesianAngle,
    ...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_cpm_ts_coding/cpm_ts_TrailerData.h>
#include <etsi_its_cpm_ts_conversion/convertCartesianAngle.h>
#include <etsi_its_cpm_ts_conversion/convertIdentifier1B.h>
#include <etsi_its_cpm_ts_conversion/convertStandardLength1B.h>
#include <etsi_its_cpm_ts_conversion/convertVehicleWidth.h>
#ifdef ROS1
#include <etsi_its_cpm_ts_msgs/TrailerData.h>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs;
#else
#include <etsi_its_cpm_ts_msgs/msg/trailer_data.hpp>
namespace cpm_ts_msgs = etsi_its_cpm_ts_msgs::msg;
#endif


namespace etsi_its_cpm_ts_conversion {

void toRos_TrailerData(const cpm_ts_TrailerData_t& in, cpm_ts_msgs::TrailerData& out) {
  toRos_Identifier1B(in.refPointId, out.ref_point_id);
  toRos_StandardLength1B(in.hitchPointOffset, out.hitch_point_offset);
  if (in.frontOverhang) {
    toRos_StandardLength1B(*in.frontOverhang, out.front_overhang);
    out.front_overhang_is_present = true;
  }
  if (in.rearOverhang) {
    toRos_StandardLength1B(*in.rearOverhang, out.rear_overhang);
    out.rear_overhang_is_present = true;
  }
  if (in.trailerWidth) {
    toRos_VehicleWidth(*in.trailerWidth, out.trailer_width);
    out.trailer_width_is_present = true;
  }
  toRos_CartesianAngle(in.hitchAngle, out.hitch_angle);
}

void toStruct_TrailerData(const cpm_ts_msgs::TrailerData& in, cpm_ts_TrailerData_t& out) {
  memset(&out, 0, sizeof(cpm_ts_TrailerData_t));
  toStruct_Identifier1B(in.ref_point_id, out.refPointId);
  toStruct_StandardLength1B(in.hitch_point_offset, out.hitchPointOffset);
  if (in.front_overhang_is_present) {
    out.frontOverhang = (cpm_ts_StandardLength1B_t*) calloc(1, sizeof(cpm_ts_StandardLength1B_t));
    toStruct_StandardLength1B(in.front_overhang, *out.frontOverhang);
  }
  if (in.rear_overhang_is_present) {
    out.rearOverhang = (cpm_ts_StandardLength1B_t*) calloc(1, sizeof(cpm_ts_StandardLength1B_t));
    toStruct_StandardLength1B(in.rear_overhang, *out.rearOverhang);
  }
  if (in.trailer_width_is_present) {
    out.trailerWidth = (cpm_ts_VehicleWidth_t*) calloc(1, sizeof(cpm_ts_VehicleWidth_t));
    toStruct_VehicleWidth(in.trailer_width, *out.trailerWidth);
  }
  toStruct_CartesianAngle(in.hitch_angle, out.hitchAngle);
}

}
