/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/patched/uulm_mcm_etsi/TS103561_LUKAS_MCM.asn \
  asn1/patched/uulm_mcm_etsi/ETSI-ITS-CDD.asn \
  -t \
  mcm_uulm \
  -o \
  etsi_its_conversion/etsi_its_mcm_uulm_conversion/include/etsi_its_mcm_uulm_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF provides the altitude and confidence level of an altitude information in a WGS84 coordinate system.
 * The specific WGS84 coordinate system is specified by the corresponding standards applying this DE.
 *
 * It shall include the following components:
 *
 * @field altitudeValue: altitude of a geographical point.
 *
 * @field altitudeConfidence: confidence level of the altitudeValue.
 *
 * @note: this DF is kept for backwards compatibility reasons only. It is recommended to use the @ref AltitudeWithConfidence instead.
 * @category: GeoReference information
 * @revision: Description revised in V2.1.1
 *
Altitude ::= SEQUENCE {
    altitudeValue         AltitudeValue,
    altitudeConfidence    AltitudeConfidence
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_mcm_uulm_coding/mcm_uulm_Altitude.h>
#include <etsi_its_mcm_uulm_conversion/convertAltitudeConfidence.h>
#include <etsi_its_mcm_uulm_conversion/convertAltitudeValue.h>
#ifdef ROS1
#include <etsi_its_mcm_uulm_msgs/Altitude.h>
namespace mcm_uulm_msgs = etsi_its_mcm_uulm_msgs;
#else
#include <etsi_its_mcm_uulm_msgs/msg/altitude.hpp>
namespace mcm_uulm_msgs = etsi_its_mcm_uulm_msgs::msg;
#endif


namespace etsi_its_mcm_uulm_conversion {

void toRos_Altitude(const mcm_uulm_Altitude_t& in, mcm_uulm_msgs::Altitude& out) {
  toRos_AltitudeValue(in.altitudeValue, out.altitude_value);
  toRos_AltitudeConfidence(in.altitudeConfidence, out.altitude_confidence);
}

void toStruct_Altitude(const mcm_uulm_msgs::Altitude& in, mcm_uulm_Altitude_t& out) {
  memset(&out, 0, sizeof(mcm_uulm_Altitude_t));
  toStruct_AltitudeValue(in.altitude_value, out.altitudeValue);
  toStruct_AltitudeConfidence(in.altitude_confidence, out.altitudeConfidence);
}

}
