/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/patched/uulm_mcm_etsi/TS103561_LUKAS_MCM.asn \
  asn1/patched/uulm_mcm_etsi/ETSI-ITS-CDD.asn \
  -t \
  mcm_uulm \
  -o \
  etsi_its_conversion/etsi_its_mcm_uulm_conversion/include/etsi_its_mcm_uulm_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
LongitudinalWaypoint ::= SEQUENCE {
	waypoint                    Waypoint,
	minArrivalTime              WaypointDeltaTime,
	maxArrivalTime              WaypointDeltaTime,
	minVelocity                 SpeedValue          OPTIONAL,
	maxVelocity                 SpeedValue          OPTIONAL,
	minDurationOfStop           WaypointDeltaTime           OPTIONAL,
	precedingRoadUser           ParticipatingRoadUserIndex  OPTIONAL,
	followingRoadUser           ParticipatingRoadUserIndex  OPTIONAL,
	yieldToRoadUserContainer    YieldToRoadUserContainer    OPTIONAL
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_mcm_uulm_coding/mcm_uulm_LongitudinalWaypoint.h>
#include <etsi_its_mcm_uulm_conversion/convertParticipatingRoadUserIndex.h>
#include <etsi_its_mcm_uulm_conversion/convertSpeedValue.h>
#include <etsi_its_mcm_uulm_conversion/convertWaypoint.h>
#include <etsi_its_mcm_uulm_conversion/convertWaypointDeltaTime.h>
#include <etsi_its_mcm_uulm_conversion/convertYieldToRoadUserContainer.h>
#ifdef ROS1
#include <etsi_its_mcm_uulm_msgs/LongitudinalWaypoint.h>
namespace mcm_uulm_msgs = etsi_its_mcm_uulm_msgs;
#else
#include <etsi_its_mcm_uulm_msgs/msg/longitudinal_waypoint.hpp>
namespace mcm_uulm_msgs = etsi_its_mcm_uulm_msgs::msg;
#endif


namespace etsi_its_mcm_uulm_conversion {

void toRos_LongitudinalWaypoint(const mcm_uulm_LongitudinalWaypoint_t& in, mcm_uulm_msgs::LongitudinalWaypoint& out) {
  toRos_Waypoint(in.waypoint, out.waypoint);
  toRos_WaypointDeltaTime(in.minArrivalTime, out.min_arrival_time);
  toRos_WaypointDeltaTime(in.maxArrivalTime, out.max_arrival_time);
  if (in.minVelocity) {
    toRos_SpeedValue(*in.minVelocity, out.min_velocity);
    out.min_velocity_is_present = true;
  }
  if (in.maxVelocity) {
    toRos_SpeedValue(*in.maxVelocity, out.max_velocity);
    out.max_velocity_is_present = true;
  }
  if (in.minDurationOfStop) {
    toRos_WaypointDeltaTime(*in.minDurationOfStop, out.min_duration_of_stop);
    out.min_duration_of_stop_is_present = true;
  }
  if (in.precedingRoadUser) {
    toRos_ParticipatingRoadUserIndex(*in.precedingRoadUser, out.preceding_road_user);
    out.preceding_road_user_is_present = true;
  }
  if (in.followingRoadUser) {
    toRos_ParticipatingRoadUserIndex(*in.followingRoadUser, out.following_road_user);
    out.following_road_user_is_present = true;
  }
  if (in.yieldToRoadUserContainer) {
    toRos_YieldToRoadUserContainer(*in.yieldToRoadUserContainer, out.yield_to_road_user_container);
    out.yield_to_road_user_container_is_present = true;
  }
}

void toStruct_LongitudinalWaypoint(const mcm_uulm_msgs::LongitudinalWaypoint& in, mcm_uulm_LongitudinalWaypoint_t& out) {
  memset(&out, 0, sizeof(mcm_uulm_LongitudinalWaypoint_t));
  toStruct_Waypoint(in.waypoint, out.waypoint);
  toStruct_WaypointDeltaTime(in.min_arrival_time, out.minArrivalTime);
  toStruct_WaypointDeltaTime(in.max_arrival_time, out.maxArrivalTime);
  if (in.min_velocity_is_present) {
    out.minVelocity = (mcm_uulm_SpeedValue_t*) calloc(1, sizeof(mcm_uulm_SpeedValue_t));
    toStruct_SpeedValue(in.min_velocity, *out.minVelocity);
  }
  if (in.max_velocity_is_present) {
    out.maxVelocity = (mcm_uulm_SpeedValue_t*) calloc(1, sizeof(mcm_uulm_SpeedValue_t));
    toStruct_SpeedValue(in.max_velocity, *out.maxVelocity);
  }
  if (in.min_duration_of_stop_is_present) {
    out.minDurationOfStop = (mcm_uulm_WaypointDeltaTime_t*) calloc(1, sizeof(mcm_uulm_WaypointDeltaTime_t));
    toStruct_WaypointDeltaTime(in.min_duration_of_stop, *out.minDurationOfStop);
  }
  if (in.preceding_road_user_is_present) {
    out.precedingRoadUser = (mcm_uulm_ParticipatingRoadUserIndex_t*) calloc(1, sizeof(mcm_uulm_ParticipatingRoadUserIndex_t));
    toStruct_ParticipatingRoadUserIndex(in.preceding_road_user, *out.precedingRoadUser);
  }
  if (in.following_road_user_is_present) {
    out.followingRoadUser = (mcm_uulm_ParticipatingRoadUserIndex_t*) calloc(1, sizeof(mcm_uulm_ParticipatingRoadUserIndex_t));
    toStruct_ParticipatingRoadUserIndex(in.following_road_user, *out.followingRoadUser);
  }
  if (in.yield_to_road_user_container_is_present) {
    out.yieldToRoadUserContainer = (mcm_uulm_YieldToRoadUserContainer_t*) calloc(1, sizeof(mcm_uulm_YieldToRoadUserContainer_t));
    toStruct_YieldToRoadUserContainer(in.yield_to_road_user_container, *out.yieldToRoadUserContainer);
  }
}

}
