/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/patched/uulm_mcm_etsi/TS103561_LUKAS_MCM.asn \
  asn1/patched/uulm_mcm_etsi/ETSI-ITS-CDD.asn \
  -t \
  mcm_uulm \
  -o \
  etsi_its_conversion/etsi_its_mcm_uulm_conversion/include/etsi_its_mcm_uulm_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
PlannedTrajectory ::= SEQUENCE {
	startDeltaTime              TrajectoryStartDeltaTime,
	deltaTime                   TrajectoryPointDeltaTime,
	trajectoryPointContainer    TrajectoryPointContainer
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_mcm_uulm_coding/mcm_uulm_PlannedTrajectory.h>
#include <etsi_its_mcm_uulm_conversion/convertTrajectoryPointContainer.h>
#include <etsi_its_mcm_uulm_conversion/convertTrajectoryPointDeltaTime.h>
#include <etsi_its_mcm_uulm_conversion/convertTrajectoryStartDeltaTime.h>
#ifdef ROS1
#include <etsi_its_mcm_uulm_msgs/PlannedTrajectory.h>
namespace mcm_uulm_msgs = etsi_its_mcm_uulm_msgs;
#else
#include <etsi_its_mcm_uulm_msgs/msg/planned_trajectory.hpp>
namespace mcm_uulm_msgs = etsi_its_mcm_uulm_msgs::msg;
#endif


namespace etsi_its_mcm_uulm_conversion {

void toRos_PlannedTrajectory(const mcm_uulm_PlannedTrajectory_t& in, mcm_uulm_msgs::PlannedTrajectory& out) {
  toRos_TrajectoryStartDeltaTime(in.startDeltaTime, out.start_delta_time);
  toRos_TrajectoryPointDeltaTime(in.deltaTime, out.delta_time);
  toRos_TrajectoryPointContainer(in.trajectoryPointContainer, out.trajectory_point_container);
}

void toStruct_PlannedTrajectory(const mcm_uulm_msgs::PlannedTrajectory& in, mcm_uulm_PlannedTrajectory_t& out) {
  memset(&out, 0, sizeof(mcm_uulm_PlannedTrajectory_t));
  toStruct_TrajectoryStartDeltaTime(in.start_delta_time, out.startDeltaTime);
  toStruct_TrajectoryPointDeltaTime(in.delta_time, out.deltaTime);
  toStruct_TrajectoryPointContainer(in.trajectory_point_container, out.trajectoryPointContainer);
}

}
