/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/patched/uulm_mcm_etsi/TS103561_LUKAS_MCM.asn \
  asn1/patched/uulm_mcm_etsi/ETSI-ITS-CDD.asn \
  -t \
  mcm_uulm \
  -o \
  etsi_its_conversion/etsi_its_mcm_uulm_conversion/include/etsi_its_mcm_uulm_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF indicates the horizontal position confidence ellipse which represents the estimated accuracy with a
 * confidence level of 95 %. The centre of the ellipse shape corresponds to the reference
 * position point for which the position accuracy is evaluated.
 *
 * It shall include the following components:
 *
 * @field semiMajorAxisLength: half of length of the major axis, i.e. distance between the centre point
 * and major axis point of the position accuracy ellipse.
 *
 * @field semiMinorAxisLength: half of length of the minor axis, i.e. distance between the centre point
 * and minor axis point of the position accuracy ellipse.
 *
 * @field semiMajorAxisOrientation: orientation direction of the ellipse major axis of the position accuracy
 * ellipse with regards to the WGS84 north.
 * The specific WGS84 coordinate system is specified by the corresponding standards applying this DE.
 *
 * @category GeoReference information
 * @revision: created in V2.1.1 based on @ref PosConfidenceEllipse
 *
PositionConfidenceEllipse ::= SEQUENCE {
    semiMajorAxisLength         SemiAxisLength,
    semiMinorAxisLength         SemiAxisLength,
    semiMajorAxisOrientation    Wgs84AngleValue
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_mcm_uulm_coding/mcm_uulm_PositionConfidenceEllipse.h>
#include <etsi_its_mcm_uulm_conversion/convertSemiAxisLength.h>
#include <etsi_its_mcm_uulm_conversion/convertWgs84AngleValue.h>
#ifdef ROS1
#include <etsi_its_mcm_uulm_msgs/PositionConfidenceEllipse.h>
namespace mcm_uulm_msgs = etsi_its_mcm_uulm_msgs;
#else
#include <etsi_its_mcm_uulm_msgs/msg/position_confidence_ellipse.hpp>
namespace mcm_uulm_msgs = etsi_its_mcm_uulm_msgs::msg;
#endif


namespace etsi_its_mcm_uulm_conversion {

void toRos_PositionConfidenceEllipse(const mcm_uulm_PositionConfidenceEllipse_t& in, mcm_uulm_msgs::PositionConfidenceEllipse& out) {
  toRos_SemiAxisLength(in.semiMajorAxisLength, out.semi_major_axis_length);
  toRos_SemiAxisLength(in.semiMinorAxisLength, out.semi_minor_axis_length);
  toRos_Wgs84AngleValue(in.semiMajorAxisOrientation, out.semi_major_axis_orientation);
}

void toStruct_PositionConfidenceEllipse(const mcm_uulm_msgs::PositionConfidenceEllipse& in, mcm_uulm_PositionConfidenceEllipse_t& out) {
  memset(&out, 0, sizeof(mcm_uulm_PositionConfidenceEllipse_t));
  toStruct_SemiAxisLength(in.semi_major_axis_length, out.semiMajorAxisLength);
  toStruct_SemiAxisLength(in.semi_minor_axis_length, out.semiMinorAxisLength);
  toStruct_Wgs84AngleValue(in.semi_major_axis_orientation, out.semiMajorAxisOrientation);
}

}
