/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/patched/uulm_mcm_etsi/TS103561_LUKAS_MCM.asn \
  asn1/patched/uulm_mcm_etsi/ETSI-ITS-CDD.asn \
  -t \
  mcm_uulm \
  -o \
  etsi_its_conversion/etsi_its_mcm_uulm_conversion/include/etsi_its_mcm_uulm_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
RoadUserContainer ::= SEQUENCE {
	roadUserState       RoadUserState,
	plannedTrajectory   PlannedTrajectory   OPTIONAL,
	desiredRoute        DesiredRoute        OPTIONAL,
	adviceResponse      AdviceResponse      OPTIONAL
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_mcm_uulm_coding/mcm_uulm_RoadUserContainer.h>
#include <etsi_its_mcm_uulm_conversion/convertAdviceResponse.h>
#include <etsi_its_mcm_uulm_conversion/convertDesiredRoute.h>
#include <etsi_its_mcm_uulm_conversion/convertPlannedTrajectory.h>
#include <etsi_its_mcm_uulm_conversion/convertRoadUserState.h>
#ifdef ROS1
#include <etsi_its_mcm_uulm_msgs/RoadUserContainer.h>
namespace mcm_uulm_msgs = etsi_its_mcm_uulm_msgs;
#else
#include <etsi_its_mcm_uulm_msgs/msg/road_user_container.hpp>
namespace mcm_uulm_msgs = etsi_its_mcm_uulm_msgs::msg;
#endif


namespace etsi_its_mcm_uulm_conversion {

void toRos_RoadUserContainer(const mcm_uulm_RoadUserContainer_t& in, mcm_uulm_msgs::RoadUserContainer& out) {
  toRos_RoadUserState(in.roadUserState, out.road_user_state);
  if (in.plannedTrajectory) {
    toRos_PlannedTrajectory(*in.plannedTrajectory, out.planned_trajectory);
    out.planned_trajectory_is_present = true;
  }
  if (in.desiredRoute) {
    toRos_DesiredRoute(*in.desiredRoute, out.desired_route);
    out.desired_route_is_present = true;
  }
  if (in.adviceResponse) {
    toRos_AdviceResponse(*in.adviceResponse, out.advice_response);
    out.advice_response_is_present = true;
  }
}

void toStruct_RoadUserContainer(const mcm_uulm_msgs::RoadUserContainer& in, mcm_uulm_RoadUserContainer_t& out) {
  memset(&out, 0, sizeof(mcm_uulm_RoadUserContainer_t));
  toStruct_RoadUserState(in.road_user_state, out.roadUserState);
  if (in.planned_trajectory_is_present) {
    out.plannedTrajectory = (mcm_uulm_PlannedTrajectory_t*) calloc(1, sizeof(mcm_uulm_PlannedTrajectory_t));
    toStruct_PlannedTrajectory(in.planned_trajectory, *out.plannedTrajectory);
  }
  if (in.desired_route_is_present) {
    out.desiredRoute = (mcm_uulm_DesiredRoute_t*) calloc(1, sizeof(mcm_uulm_DesiredRoute_t));
    toStruct_DesiredRoute(in.desired_route, *out.desiredRoute);
  }
  if (in.advice_response_is_present) {
    out.adviceResponse = (mcm_uulm_AdviceResponse_t*) calloc(1, sizeof(mcm_uulm_AdviceResponse_t));
    toStruct_AdviceResponse(in.advice_response, *out.adviceResponse);
  }
}

}
