/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/patched/uulm_mcm_etsi/TS103561_LUKAS_MCM.asn \
  asn1/patched/uulm_mcm_etsi/ETSI-ITS-CDD.asn \
  -t \
  mcm_uulm \
  -o \
  etsi_its_conversion/etsi_its_mcm_uulm_conversion/include/etsi_its_mcm_uulm_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DE represents an angle value in degrees described in the WGS84 reference system with respect to the WGS84 north.
 * The specific WGS84 coordinate system is specified by the corresponding standards applying this DE.
 * When the information is not available, the DE shall be set to 3 601. The value 3600 shall not be used.
 *
 * @unit 0,1 degrees
 * @category: GeoReference Information
 * @revision: Created in V2.1.1
*
Wgs84AngleValue ::= INTEGER {
    wgs84North  (0),
    wgs84East   (900),
    wgs84South  (1800),
    wgs84West   (2700),
    doNotUse    (3600),
    unavailable (3601)
} (0..3601)
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_mcm_uulm_coding/mcm_uulm_Wgs84AngleValue.h>
#include <etsi_its_mcm_uulm_coding/INTEGER.h>
#include <etsi_its_primitives_conversion/convertINTEGER.h>
#ifdef ROS1
#include <etsi_its_mcm_uulm_msgs/Wgs84AngleValue.h>
namespace mcm_uulm_msgs = etsi_its_mcm_uulm_msgs;
#else
#include <etsi_its_mcm_uulm_msgs/msg/wgs84_angle_value.hpp>
namespace mcm_uulm_msgs = etsi_its_mcm_uulm_msgs::msg;
#endif


namespace etsi_its_mcm_uulm_conversion {

void toRos_Wgs84AngleValue(const mcm_uulm_Wgs84AngleValue_t& in, mcm_uulm_msgs::Wgs84AngleValue& out) {
  etsi_its_primitives_conversion::toRos_INTEGER(in, out.value);
}

void toStruct_Wgs84AngleValue(const mcm_uulm_msgs::Wgs84AngleValue& in, mcm_uulm_Wgs84AngleValue_t& out) {
  memset(&out, 0, sizeof(mcm_uulm_Wgs84AngleValue_t));
  etsi_its_primitives_conversion::toStruct_INTEGER(in.value, out);
}

}
