/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF represents an acceleration vector with associated confidence value.
 *
 * It shall include the following components: 
 * 
 * @field polarAcceleration: the representation of the acceleration vector in a polar or cylindrical coordinate system. 
 * 
 * @field cartesianAcceleration: the representation of the acceleration vector in a cartesian coordinate system.
 * 
 * @category: Kinematic information
 * @revision: Created in V2.1.1
 *
Acceleration3dWithConfidence::= CHOICE {
    polarAcceleration                    AccelerationPolarWithZ,
    cartesianAcceleration                AccelerationCartesian 
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_Acceleration3dWithConfidence.h>
#include <etsi_its_denm_ts_conversion/convertAccelerationCartesian.h>
#include <etsi_its_denm_ts_conversion/convertAccelerationPolarWithZ.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/Acceleration3dWithConfidence.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/acceleration3d_with_confidence.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_Acceleration3dWithConfidence(const denm_ts_Acceleration3dWithConfidence_t& in, denm_ts_msgs::Acceleration3dWithConfidence& out) {
  switch (in.present) {
  case denm_ts_Acceleration3dWithConfidence_PR_polarAcceleration:
    toRos_AccelerationPolarWithZ(in.choice.polarAcceleration, out.polar_acceleration);
    out.choice = denm_ts_msgs::Acceleration3dWithConfidence::CHOICE_POLAR_ACCELERATION;
    break;
  case denm_ts_Acceleration3dWithConfidence_PR_cartesianAcceleration:
    toRos_AccelerationCartesian(in.choice.cartesianAcceleration, out.cartesian_acceleration);
    out.choice = denm_ts_msgs::Acceleration3dWithConfidence::CHOICE_CARTESIAN_ACCELERATION;
    break;
  default: break;
  }
}

void toStruct_Acceleration3dWithConfidence(const denm_ts_msgs::Acceleration3dWithConfidence& in, denm_ts_Acceleration3dWithConfidence_t& out) {
  memset(&out, 0, sizeof(denm_ts_Acceleration3dWithConfidence_t));
  switch (in.choice) {
  case denm_ts_msgs::Acceleration3dWithConfidence::CHOICE_POLAR_ACCELERATION:
    toStruct_AccelerationPolarWithZ(in.polar_acceleration, out.choice.polarAcceleration);
    out.present = denm_ts_Acceleration3dWithConfidence_PR::denm_ts_Acceleration3dWithConfidence_PR_polarAcceleration;
    break;
  case denm_ts_msgs::Acceleration3dWithConfidence::CHOICE_CARTESIAN_ACCELERATION:
    toStruct_AccelerationCartesian(in.cartesian_acceleration, out.choice.cartesianAcceleration);
    out.present = denm_ts_Acceleration3dWithConfidence_PR::denm_ts_Acceleration3dWithConfidence_PR_cartesianAcceleration;
    break;
  default: break;
  }
}

}
