/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF represents a acceleration vector in a cartesian coordinate system.
 
 * It shall include the following components: 
 * 
 * @field xAcceleration: the x component of the acceleration vector with the associated confidence value.
 * 
 * @field yAcceleration: the y component of the acceleration vector with the associated confidence value.
 *
 * @field zAcceleration: the optional z component of the acceleration vector with the associated confidence value.
 * 
 * @category: Kinematic information
 * @revision: Created in V2.1.1
 *
AccelerationCartesian::= SEQUENCE{
    xAcceleration      AccelerationComponent,
    yAcceleration      AccelerationComponent,
    zAcceleration      AccelerationComponent OPTIONAL
}            
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_AccelerationCartesian.h>
#include <etsi_its_denm_ts_conversion/convertAccelerationComponent.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/AccelerationCartesian.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/acceleration_cartesian.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_AccelerationCartesian(const denm_ts_AccelerationCartesian_t& in, denm_ts_msgs::AccelerationCartesian& out) {
  toRos_AccelerationComponent(in.xAcceleration, out.x_acceleration);
  toRos_AccelerationComponent(in.yAcceleration, out.y_acceleration);
  if (in.zAcceleration) {
    toRos_AccelerationComponent(*in.zAcceleration, out.z_acceleration);
    out.z_acceleration_is_present = true;
  }
}

void toStruct_AccelerationCartesian(const denm_ts_msgs::AccelerationCartesian& in, denm_ts_AccelerationCartesian_t& out) {
  memset(&out, 0, sizeof(denm_ts_AccelerationCartesian_t));
  toStruct_AccelerationComponent(in.x_acceleration, out.xAcceleration);
  toStruct_AccelerationComponent(in.y_acceleration, out.yAcceleration);
  if (in.z_acceleration_is_present) {
    out.zAcceleration = (denm_ts_AccelerationComponent_t*) calloc(1, sizeof(denm_ts_AccelerationComponent_t));
    toStruct_AccelerationComponent(in.z_acceleration, *out.zAcceleration);
  }
}

}
