/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This type represents the A La Carte Container.
 *
 * It shall include the following components: 
 *
 * @field lanePosition: the optional lane position of the event.
 *
 * @field impactReduction: optional vehicle data for collision mitigation.
 *
 * @field externalTemperature: optional the ambient temperature at the event position.
 *
 * @field roadWorks: optional information of the roadwork zone.
 *
 * @field positioningSolution: optionally indicates the technical solution being used by the originating ITS-S to estimate the event position.
 *
 * @field stationaryVehicle: optional information about a stationary vehicle.
 *
 * @field roadConfiguration: optional information about the configuration of the road.
 *
 * @field precrash: the optional information about perceived objects that represent hazards and/or could be subject of collisions. 
 *
*
AlacarteContainer ::= SEQUENCE {
    lanePosition        LanePosition OPTIONAL,
    impactReduction     ImpactReductionContainer OPTIONAL,
    externalTemperature Temperature OPTIONAL,
    roadWorks           RoadWorksContainerExtended OPTIONAL,
    positioningSolution PositioningSolutionType OPTIONAL,
    stationaryVehicle   StationaryVehicleContainer OPTIONAL,
    ...,
[[  roadConfiguration 	RoadConfigurationContainer OPTIONAL,
    preCrash            PreCrashContainer OPTIONAL ]]
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_AlacarteContainer.h>
#include <etsi_its_denm_ts_conversion/convertImpactReductionContainer.h>
#include <etsi_its_denm_ts_conversion/convertLanePosition.h>
#include <etsi_its_denm_ts_conversion/convertPositioningSolutionType.h>
#include <etsi_its_denm_ts_conversion/convertPreCrashContainer.h>
#include <etsi_its_denm_ts_conversion/convertRoadConfigurationContainer.h>
#include <etsi_its_denm_ts_conversion/convertRoadWorksContainerExtended.h>
#include <etsi_its_denm_ts_conversion/convertStationaryVehicleContainer.h>
#include <etsi_its_denm_ts_conversion/convertTemperature.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/AlacarteContainer.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/alacarte_container.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_AlacarteContainer(const denm_ts_AlacarteContainer_t& in, denm_ts_msgs::AlacarteContainer& out) {
  if (in.lanePosition) {
    toRos_LanePosition(*in.lanePosition, out.lane_position);
    out.lane_position_is_present = true;
  }
  if (in.impactReduction) {
    toRos_ImpactReductionContainer(*in.impactReduction, out.impact_reduction);
    out.impact_reduction_is_present = true;
  }
  if (in.externalTemperature) {
    toRos_Temperature(*in.externalTemperature, out.external_temperature);
    out.external_temperature_is_present = true;
  }
  if (in.roadWorks) {
    toRos_RoadWorksContainerExtended(*in.roadWorks, out.road_works);
    out.road_works_is_present = true;
  }
  if (in.positioningSolution) {
    toRos_PositioningSolutionType(*in.positioningSolution, out.positioning_solution);
    out.positioning_solution_is_present = true;
  }
  if (in.stationaryVehicle) {
    toRos_StationaryVehicleContainer(*in.stationaryVehicle, out.stationary_vehicle);
    out.stationary_vehicle_is_present = true;
  }
  if (in.ext1->roadConfiguration) {
    toRos_RoadConfigurationContainer(*in.ext1->roadConfiguration, out.road_configuration);
    out.road_configuration_is_present = true;
  }
  if (in.ext1->preCrash) {
    toRos_PreCrashContainer(*in.ext1->preCrash, out.pre_crash);
    out.pre_crash_is_present = true;
  }
}

void toStruct_AlacarteContainer(const denm_ts_msgs::AlacarteContainer& in, denm_ts_AlacarteContainer_t& out) {
  memset(&out, 0, sizeof(denm_ts_AlacarteContainer_t));
  if (in.lane_position_is_present) {
    out.lanePosition = (denm_ts_LanePosition_t*) calloc(1, sizeof(denm_ts_LanePosition_t));
    toStruct_LanePosition(in.lane_position, *out.lanePosition);
  }
  if (in.impact_reduction_is_present) {
    out.impactReduction = (denm_ts_ImpactReductionContainer_t*) calloc(1, sizeof(denm_ts_ImpactReductionContainer_t));
    toStruct_ImpactReductionContainer(in.impact_reduction, *out.impactReduction);
  }
  if (in.external_temperature_is_present) {
    out.externalTemperature = (denm_ts_Temperature_t*) calloc(1, sizeof(denm_ts_Temperature_t));
    toStruct_Temperature(in.external_temperature, *out.externalTemperature);
  }
  if (in.road_works_is_present) {
    out.roadWorks = (denm_ts_RoadWorksContainerExtended_t*) calloc(1, sizeof(denm_ts_RoadWorksContainerExtended_t));
    toStruct_RoadWorksContainerExtended(in.road_works, *out.roadWorks);
  }
  if (in.positioning_solution_is_present) {
    out.positioningSolution = (denm_ts_PositioningSolutionType_t*) calloc(1, sizeof(denm_ts_PositioningSolutionType_t));
    toStruct_PositioningSolutionType(in.positioning_solution, *out.positioningSolution);
  }
  if (in.stationary_vehicle_is_present) {
    out.stationaryVehicle = (denm_ts_StationaryVehicleContainer_t*) calloc(1, sizeof(denm_ts_StationaryVehicleContainer_t));
    toStruct_StationaryVehicleContainer(in.stationary_vehicle, *out.stationaryVehicle);
  }
  if (in.road_configuration_is_present) {
    out.ext1->roadConfiguration = (denm_ts_RoadConfigurationContainer_t*) calloc(1, sizeof(denm_ts_RoadConfigurationContainer_t));
    toStruct_RoadConfigurationContainer(in.road_configuration, *out.ext1->roadConfiguration);
  }
  if (in.pre_crash_is_present) {
    out.ext1->preCrash = (denm_ts_PreCrashContainer_t*) calloc(1, sizeof(denm_ts_PreCrashContainer_t));
    toStruct_PreCrashContainer(in.pre_crash, *out.ext1->preCrash);
  }
}

}
