/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DF provides basic information about a single lane of a road segment.
 * It includes the following components: 
 * 
 * @field laneNumber: the number associated to the lane that provides a transversal identification. 
 * 
 * @field direction: the direction of traffic flow allowed on the lane. 
 * 
 * @field laneWidth: the optional width of the lane.
 *
 * @field connectingLane: the number of the connecting lane in the next road section, i.e. the number of the lane which the vehicle will use when travelling from one section to the next,
 * if it does not actively change lanes. If this component is absent, the lane name number remains the same in the next section.
 *
 * @field connectingRoadSection: the identifier of the next road section in direction of traffic, that is connecting to the current road section. 
 * If this component is absent, the connecting road section is the one following the instance where this DF is placed in the @ref RoadConfigurationSectionList.
 *
 * @category: Road topology information
 * @revision: Created in V2.2.1
*
BasicLaneInformation::= SEQUENCE{
  laneNumber	         LanePosition,
  direction		         Direction,
  laneWidth		         LaneWidth OPTIONAL,
  connectingLane         LanePosition OPTIONAL,
  connectingRoadSection  RoadSectionId OPTIONAL,
  ...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_BasicLaneInformation.h>
#include <etsi_its_denm_ts_conversion/convertDirection.h>
#include <etsi_its_denm_ts_conversion/convertLanePosition.h>
#include <etsi_its_denm_ts_conversion/convertLaneWidth.h>
#include <etsi_its_denm_ts_conversion/convertRoadSectionId.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/BasicLaneInformation.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/basic_lane_information.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_BasicLaneInformation(const denm_ts_BasicLaneInformation_t& in, denm_ts_msgs::BasicLaneInformation& out) {
  toRos_LanePosition(in.laneNumber, out.lane_number);
  toRos_Direction(in.direction, out.direction);
  if (in.laneWidth) {
    toRos_LaneWidth(*in.laneWidth, out.lane_width);
    out.lane_width_is_present = true;
  }
  if (in.connectingLane) {
    toRos_LanePosition(*in.connectingLane, out.connecting_lane);
    out.connecting_lane_is_present = true;
  }
  if (in.connectingRoadSection) {
    toRos_RoadSectionId(*in.connectingRoadSection, out.connecting_road_section);
    out.connecting_road_section_is_present = true;
  }
}

void toStruct_BasicLaneInformation(const denm_ts_msgs::BasicLaneInformation& in, denm_ts_BasicLaneInformation_t& out) {
  memset(&out, 0, sizeof(denm_ts_BasicLaneInformation_t));
  toStruct_LanePosition(in.lane_number, out.laneNumber);
  toStruct_Direction(in.direction, out.direction);
  if (in.lane_width_is_present) {
    out.laneWidth = (denm_ts_LaneWidth_t*) calloc(1, sizeof(denm_ts_LaneWidth_t));
    toStruct_LaneWidth(in.lane_width, *out.laneWidth);
  }
  if (in.connecting_lane_is_present) {
    out.connectingLane = (denm_ts_LanePosition_t*) calloc(1, sizeof(denm_ts_LanePosition_t));
    toStruct_LanePosition(in.connecting_lane, *out.connectingLane);
  }
  if (in.connecting_road_section_is_present) {
    out.connectingRoadSection = (denm_ts_RoadSectionId_t*) calloc(1, sizeof(denm_ts_RoadSectionId_t));
    toStruct_RoadSectionId(in.connecting_road_section, *out.connectingRoadSection);
  }
}

}
