/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF is a representation of the cause code value and associated sub cause code value of a traffic event. 
 *
 * The following options are available:
 * - 0                                                        - reserved for future use,
 * - 1  - `trafficCondition1`                                 - in case the type of event is an abnormal traffic condition,
 * - 2  - `accident2`                                         - in case the type of event is a road accident,
 * - 3  - `roadworks3`                                        - in case the type of event is roadwork,
 * - 4                                                        - reserved for future usage,
 * - 5  - `impassability5`                                    - in case the  type of event is unmanaged road blocking, referring to any
 *                                                              blocking of a road, partial or total, which has not been adequately secured and signposted,
 * - 6  - `adverseWeatherCondition-Adhesion6`                 - in case the  type of event is low adhesion,
 * - 7  - `aquaplaning7`                                      - danger of aquaplaning on the road,
 * - 8                                                        - reserved for future usage,
 * - 9  - `hazardousLocation-SurfaceCondition9`               - in case the type of event is abnormal road surface condition,
 * - 10 - `hazardousLocation-ObstacleOnTheRoad10`             - in case the type of event is obstacle on the road,
 * - 11 - `hazardousLocation-AnimalOnTheRoad11`               - in case the type of event is animal on the road,
 * - 12 - `humanPresenceOnTheRoad`                            - in case the type of event is presence of human vulnerable road user on the road,
 * - 13                                                       - reserved for future usage,
 * - 14 - `wrongWayDriving14`                                 - in case the type of the event is vehicle driving in wrong way,
 * - 15 - `rescueAndRecoveryWorkInProgress15`                 - in case the type of event is rescue and recovery work for accident or for a road hazard in progress,
 * - 16                                                       - reserved for future usage,
 * - 17 - `adverseWeatherCondition-ExtremeWeatherCondition17` - in case the type of event is extreme weather condition,
 * - 18 - `adverseWeatherCondition-Visibility18`              - in case the type of event is low visibility,
 * - 19 - `adverseWeatherCondition-Precipitation19`           - in case the type of event is precipitation,
 * - 20 - `violence20`                                        - in case the the type of event is human violence on or near the road,
 * - 21-25                                                    - reserved for future usage,
 * - 26 - `slowVehicle26`                                     - in case the type of event is slow vehicle driving on the road,
 * - 27 - `dangerousEndOfQueue27`                             - in case the type of event is dangerous end of vehicle queue,
 * - 28 - `publicTransportVehicleApproaching                  - in case the type of event is a public transport vehicle approaching, with a priority defined by applicable traffic regulations,
 * - 29-90                                                    - are reserved for future usage,
 * - 91 - `vehicleBreakdown91`                                - in case the type of event is break down vehicle on the road,
 * - 92 - `postCrash92`                                       - in case the type of event is a detected crash,
 * - 93 - `humanProblem93`                                    - in case the type of event is human health problem in vehicles involved in traffic,
 * - 94 - `stationaryVehicle94`                               - in case the type of event is stationary vehicle,
 * - 95 - `emergencyVehicleApproaching95`                     - in case the type of event is an approaching vehicle operating on a mission for which the 
                                                                applicable traffic regulations provide it with defined priority rights in traffic. 
 * - 96 - `hazardousLocation-DangerousCurve96`                - in case the type of event is dangerous curve,
 * - 97 - `collisionRisk97`                                   - in case the type of event is a collision risk,
 * - 98 - `signalViolation98`                                 - in case the type of event is signal violation,
 * - 99 - `dangerousSituation99`                              - in case the type of event is dangerous situation in which autonomous safety system in vehicle 
 *                                                              is activated,
 * - 100 - `railwayLevelCrossing100`                          - in case the type of event is a railway level crossing. 
 * - 101-255                                                  - are reserved for future usage.
 *
 * @note: this DF is defined for use as part of CauseCodeV2. It is recommended to use CauseCodeV2.
 * @category: Traffic information
 * @revision: Created in V2.1.1, the type of impassability5 changed to ImpassabilitySubCauseCode in V2.2.1, value 28 added in V2.2.1, definition of value 12 and 95 changed in V2.2.1
 *
CauseCodeChoice::= CHOICE {
    reserved0                                          SubCauseCodeType,
    trafficCondition1                                  TrafficConditionSubCauseCode,
    accident2                                          AccidentSubCauseCode,
    roadworks3                                         RoadworksSubCauseCode,
    reserved4                                          SubCauseCodeType,
    impassability5                                     ImpassabilitySubCauseCode,
    adverseWeatherCondition-Adhesion6                  AdverseWeatherCondition-AdhesionSubCauseCode,
    aquaplaning7                                       SubCauseCodeType,
    reserved8                                          SubCauseCodeType,
    hazardousLocation-SurfaceCondition9                HazardousLocation-SurfaceConditionSubCauseCode,
    hazardousLocation-ObstacleOnTheRoad10              HazardousLocation-ObstacleOnTheRoadSubCauseCode,
    hazardousLocation-AnimalOnTheRoad11                HazardousLocation-AnimalOnTheRoadSubCauseCode,
    humanPresenceOnTheRoad12                           HumanPresenceOnTheRoadSubCauseCode,
    reserved13                                         SubCauseCodeType,
    wrongWayDriving14                                  WrongWayDrivingSubCauseCode,
    rescueAndRecoveryWorkInProgress15                  RescueAndRecoveryWorkInProgressSubCauseCode,
    reserved16                                         SubCauseCodeType,
    adverseWeatherCondition-ExtremeWeatherCondition17  AdverseWeatherCondition-ExtremeWeatherConditionSubCauseCode,
    adverseWeatherCondition-Visibility18               AdverseWeatherCondition-VisibilitySubCauseCode,
    adverseWeatherCondition-Precipitation19            AdverseWeatherCondition-PrecipitationSubCauseCode,
    violence20                                         SubCauseCodeType,
    reserved21                                         SubCauseCodeType,
    reserved22                                         SubCauseCodeType,
    reserved23                                         SubCauseCodeType,
    reserved24                                         SubCauseCodeType,
    reserved25                                         SubCauseCodeType,
    slowVehicle26                                      SlowVehicleSubCauseCode,
    dangerousEndOfQueue27                              DangerousEndOfQueueSubCauseCode,
    publicTransportVehicleApproaching28                SubCauseCodeType,
    reserved29                                         SubCauseCodeType,
    reserved30                                         SubCauseCodeType,
    reserved31                                         SubCauseCodeType,
    reserved32                                         SubCauseCodeType,
    reserved33                                         SubCauseCodeType,
    reserved34                                         SubCauseCodeType,
    reserved35                                         SubCauseCodeType,
    reserved36                                         SubCauseCodeType,
    reserved37                                         SubCauseCodeType,
    reserved38                                         SubCauseCodeType,
    reserved39                                         SubCauseCodeType,
    reserved40                                         SubCauseCodeType,
    reserved41                                         SubCauseCodeType,
    reserved42                                         SubCauseCodeType,
    reserved43                                         SubCauseCodeType,
    reserved44                                         SubCauseCodeType,
    reserved45                                         SubCauseCodeType,
    reserved46                                         SubCauseCodeType,
    reserved47                                         SubCauseCodeType,
    reserved48                                         SubCauseCodeType,
    reserved49                                         SubCauseCodeType,
    reserved50                                         SubCauseCodeType,
    reserved51                                         SubCauseCodeType,
    reserved52                                         SubCauseCodeType,
    reserved53                                         SubCauseCodeType,
    reserved54                                         SubCauseCodeType,
    reserved55                                         SubCauseCodeType,
    reserved56                                         SubCauseCodeType,
    reserved57                                         SubCauseCodeType,
    reserved58                                         SubCauseCodeType,   
    reserved59                                         SubCauseCodeType, 
    reserved60                                         SubCauseCodeType,
    reserved61                                         SubCauseCodeType,
    reserved62                                         SubCauseCodeType,
    reserved63                                         SubCauseCodeType,
    reserved64                                         SubCauseCodeType,
    reserved65                                         SubCauseCodeType,
    reserved66                                         SubCauseCodeType,    
    reserved67                                         SubCauseCodeType,
    reserved68                                         SubCauseCodeType,
    reserved69                                         SubCauseCodeType,
    reserved70                                         SubCauseCodeType,
    reserved71                                         SubCauseCodeType,
    reserved72                                         SubCauseCodeType,
    reserved73                                         SubCauseCodeType,
    reserved74                                         SubCauseCodeType,
    reserved75                                         SubCauseCodeType,
    reserved76                                         SubCauseCodeType,
    reserved77                                         SubCauseCodeType,
    reserved78                                         SubCauseCodeType,
    reserved79                                         SubCauseCodeType,
    reserved80                                         SubCauseCodeType,
    reserved81                                         SubCauseCodeType,
    reserved82                                         SubCauseCodeType,
    reserved83                                         SubCauseCodeType,
    reserved84                                         SubCauseCodeType,
    reserved85                                         SubCauseCodeType,
    reserved86                                         SubCauseCodeType,
    reserved87                                         SubCauseCodeType,
    reserved88                                         SubCauseCodeType,
    reserved89                                         SubCauseCodeType,
    reserved90                                         SubCauseCodeType,
    vehicleBreakdown91                                 VehicleBreakdownSubCauseCode,
    postCrash92                                        PostCrashSubCauseCode,
    humanProblem93                                     HumanProblemSubCauseCode,
    stationaryVehicle94                                StationaryVehicleSubCauseCode,
    emergencyVehicleApproaching95                      EmergencyVehicleApproachingSubCauseCode,
    hazardousLocation-DangerousCurve96                 HazardousLocation-DangerousCurveSubCauseCode,
    collisionRisk97                                    CollisionRiskSubCauseCode,
    signalViolation98                                  SignalViolationSubCauseCode,
    dangerousSituation99                               DangerousSituationSubCauseCode,
    railwayLevelCrossing100                            RailwayLevelCrossingSubCauseCode,
    reserved101                                        SubCauseCodeType,
    reserved102                                        SubCauseCodeType,
    reserved103                                        SubCauseCodeType,
    reserved104                                        SubCauseCodeType,
    reserved105                                        SubCauseCodeType,
    reserved106                                        SubCauseCodeType,
    reserved107                                        SubCauseCodeType,
    reserved108                                        SubCauseCodeType,
    reserved109                                        SubCauseCodeType,
    reserved110                                        SubCauseCodeType,
    reserved111                                        SubCauseCodeType,
    reserved112                                        SubCauseCodeType,
    reserved113                                        SubCauseCodeType,
    reserved114                                        SubCauseCodeType,
    reserved115                                        SubCauseCodeType,
    reserved116                                        SubCauseCodeType,
    reserved117                                        SubCauseCodeType,
    reserved118                                        SubCauseCodeType,
    reserved119                                        SubCauseCodeType,
    reserved120                                        SubCauseCodeType,
    reserved121                                        SubCauseCodeType,
    reserved122                                        SubCauseCodeType,
    reserved123                                        SubCauseCodeType,
    reserved124                                        SubCauseCodeType,
    reserved125                                        SubCauseCodeType,
    reserved126                                        SubCauseCodeType,
    reserved127                                        SubCauseCodeType,
    reserved128                                        SubCauseCodeType
  }
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_CauseCodeChoice.h>
#include <etsi_its_denm_ts_conversion/convertAccidentSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertAdverseWeatherConditionAdhesionSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertAdverseWeatherConditionExtremeWeatherConditionSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertAdverseWeatherConditionPrecipitationSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertAdverseWeatherConditionVisibilitySubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertCollisionRiskSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertDangerousEndOfQueueSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertDangerousSituationSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertEmergencyVehicleApproachingSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertHazardousLocationAnimalOnTheRoadSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertHazardousLocationDangerousCurveSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertHazardousLocationObstacleOnTheRoadSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertHazardousLocationSurfaceConditionSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertHumanPresenceOnTheRoadSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertHumanProblemSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertImpassabilitySubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertPostCrashSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertRailwayLevelCrossingSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertRescueAndRecoveryWorkInProgressSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertRoadworksSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertSignalViolationSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertSlowVehicleSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertStationaryVehicleSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertSubCauseCodeType.h>
#include <etsi_its_denm_ts_conversion/convertTrafficConditionSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertVehicleBreakdownSubCauseCode.h>
#include <etsi_its_denm_ts_conversion/convertWrongWayDrivingSubCauseCode.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/CauseCodeChoice.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/cause_code_choice.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_CauseCodeChoice(const denm_ts_CauseCodeChoice_t& in, denm_ts_msgs::CauseCodeChoice& out) {
  switch (in.present) {
  case denm_ts_CauseCodeChoice_PR_reserved0:
    toRos_SubCauseCodeType(in.choice.reserved0, out.reserved0);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED0;
    break;
  case denm_ts_CauseCodeChoice_PR_trafficCondition1:
    toRos_TrafficConditionSubCauseCode(in.choice.trafficCondition1, out.traffic_condition1);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_TRAFFIC_CONDITION1;
    break;
  case denm_ts_CauseCodeChoice_PR_accident2:
    toRos_AccidentSubCauseCode(in.choice.accident2, out.accident2);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_ACCIDENT2;
    break;
  case denm_ts_CauseCodeChoice_PR_roadworks3:
    toRos_RoadworksSubCauseCode(in.choice.roadworks3, out.roadworks3);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_ROADWORKS3;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved4:
    toRos_SubCauseCodeType(in.choice.reserved4, out.reserved4);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED4;
    break;
  case denm_ts_CauseCodeChoice_PR_impassability5:
    toRos_ImpassabilitySubCauseCode(in.choice.impassability5, out.impassability5);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_IMPASSABILITY5;
    break;
  case denm_ts_CauseCodeChoice_PR_adverseWeatherCondition_Adhesion6:
    toRos_AdverseWeatherConditionAdhesionSubCauseCode(in.choice.adverseWeatherCondition_Adhesion6, out.adverse_weather_condition_adhesion6);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_ADVERSE_WEATHER_CONDITION_ADHESION6;
    break;
  case denm_ts_CauseCodeChoice_PR_aquaplaning7:
    toRos_SubCauseCodeType(in.choice.aquaplaning7, out.aquaplaning7);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_AQUAPLANING7;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved8:
    toRos_SubCauseCodeType(in.choice.reserved8, out.reserved8);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED8;
    break;
  case denm_ts_CauseCodeChoice_PR_hazardousLocation_SurfaceCondition9:
    toRos_HazardousLocationSurfaceConditionSubCauseCode(in.choice.hazardousLocation_SurfaceCondition9, out.hazardous_location_surface_condition9);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_HAZARDOUS_LOCATION_SURFACE_CONDITION9;
    break;
  case denm_ts_CauseCodeChoice_PR_hazardousLocation_ObstacleOnTheRoad10:
    toRos_HazardousLocationObstacleOnTheRoadSubCauseCode(in.choice.hazardousLocation_ObstacleOnTheRoad10, out.hazardous_location_obstacle_on_the_road10);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_HAZARDOUS_LOCATION_OBSTACLE_ON_THE_ROAD10;
    break;
  case denm_ts_CauseCodeChoice_PR_hazardousLocation_AnimalOnTheRoad11:
    toRos_HazardousLocationAnimalOnTheRoadSubCauseCode(in.choice.hazardousLocation_AnimalOnTheRoad11, out.hazardous_location_animal_on_the_road11);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_HAZARDOUS_LOCATION_ANIMAL_ON_THE_ROAD11;
    break;
  case denm_ts_CauseCodeChoice_PR_humanPresenceOnTheRoad12:
    toRos_HumanPresenceOnTheRoadSubCauseCode(in.choice.humanPresenceOnTheRoad12, out.human_presence_on_the_road12);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_HUMAN_PRESENCE_ON_THE_ROAD12;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved13:
    toRos_SubCauseCodeType(in.choice.reserved13, out.reserved13);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED13;
    break;
  case denm_ts_CauseCodeChoice_PR_wrongWayDriving14:
    toRos_WrongWayDrivingSubCauseCode(in.choice.wrongWayDriving14, out.wrong_way_driving14);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_WRONG_WAY_DRIVING14;
    break;
  case denm_ts_CauseCodeChoice_PR_rescueAndRecoveryWorkInProgress15:
    toRos_RescueAndRecoveryWorkInProgressSubCauseCode(in.choice.rescueAndRecoveryWorkInProgress15, out.rescue_and_recovery_work_in_progress15);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESCUE_AND_RECOVERY_WORK_IN_PROGRESS15;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved16:
    toRos_SubCauseCodeType(in.choice.reserved16, out.reserved16);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED16;
    break;
  case denm_ts_CauseCodeChoice_PR_adverseWeatherCondition_ExtremeWeatherCondition17:
    toRos_AdverseWeatherConditionExtremeWeatherConditionSubCauseCode(in.choice.adverseWeatherCondition_ExtremeWeatherCondition17, out.adverse_weather_condition_extreme_weather_condition17);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_ADVERSE_WEATHER_CONDITION_EXTREME_WEATHER_CONDITION17;
    break;
  case denm_ts_CauseCodeChoice_PR_adverseWeatherCondition_Visibility18:
    toRos_AdverseWeatherConditionVisibilitySubCauseCode(in.choice.adverseWeatherCondition_Visibility18, out.adverse_weather_condition_visibility18);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_ADVERSE_WEATHER_CONDITION_VISIBILITY18;
    break;
  case denm_ts_CauseCodeChoice_PR_adverseWeatherCondition_Precipitation19:
    toRos_AdverseWeatherConditionPrecipitationSubCauseCode(in.choice.adverseWeatherCondition_Precipitation19, out.adverse_weather_condition_precipitation19);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_ADVERSE_WEATHER_CONDITION_PRECIPITATION19;
    break;
  case denm_ts_CauseCodeChoice_PR_violence20:
    toRos_SubCauseCodeType(in.choice.violence20, out.violence20);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_VIOLENCE20;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved21:
    toRos_SubCauseCodeType(in.choice.reserved21, out.reserved21);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED21;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved22:
    toRos_SubCauseCodeType(in.choice.reserved22, out.reserved22);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED22;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved23:
    toRos_SubCauseCodeType(in.choice.reserved23, out.reserved23);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED23;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved24:
    toRos_SubCauseCodeType(in.choice.reserved24, out.reserved24);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED24;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved25:
    toRos_SubCauseCodeType(in.choice.reserved25, out.reserved25);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED25;
    break;
  case denm_ts_CauseCodeChoice_PR_slowVehicle26:
    toRos_SlowVehicleSubCauseCode(in.choice.slowVehicle26, out.slow_vehicle26);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_SLOW_VEHICLE26;
    break;
  case denm_ts_CauseCodeChoice_PR_dangerousEndOfQueue27:
    toRos_DangerousEndOfQueueSubCauseCode(in.choice.dangerousEndOfQueue27, out.dangerous_end_of_queue27);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_DANGEROUS_END_OF_QUEUE27;
    break;
  case denm_ts_CauseCodeChoice_PR_publicTransportVehicleApproaching28:
    toRos_SubCauseCodeType(in.choice.publicTransportVehicleApproaching28, out.public_transport_vehicle_approaching28);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_PUBLIC_TRANSPORT_VEHICLE_APPROACHING28;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved29:
    toRos_SubCauseCodeType(in.choice.reserved29, out.reserved29);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED29;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved30:
    toRos_SubCauseCodeType(in.choice.reserved30, out.reserved30);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED30;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved31:
    toRos_SubCauseCodeType(in.choice.reserved31, out.reserved31);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED31;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved32:
    toRos_SubCauseCodeType(in.choice.reserved32, out.reserved32);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED32;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved33:
    toRos_SubCauseCodeType(in.choice.reserved33, out.reserved33);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED33;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved34:
    toRos_SubCauseCodeType(in.choice.reserved34, out.reserved34);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED34;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved35:
    toRos_SubCauseCodeType(in.choice.reserved35, out.reserved35);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED35;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved36:
    toRos_SubCauseCodeType(in.choice.reserved36, out.reserved36);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED36;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved37:
    toRos_SubCauseCodeType(in.choice.reserved37, out.reserved37);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED37;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved38:
    toRos_SubCauseCodeType(in.choice.reserved38, out.reserved38);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED38;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved39:
    toRos_SubCauseCodeType(in.choice.reserved39, out.reserved39);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED39;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved40:
    toRos_SubCauseCodeType(in.choice.reserved40, out.reserved40);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED40;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved41:
    toRos_SubCauseCodeType(in.choice.reserved41, out.reserved41);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED41;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved42:
    toRos_SubCauseCodeType(in.choice.reserved42, out.reserved42);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED42;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved43:
    toRos_SubCauseCodeType(in.choice.reserved43, out.reserved43);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED43;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved44:
    toRos_SubCauseCodeType(in.choice.reserved44, out.reserved44);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED44;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved45:
    toRos_SubCauseCodeType(in.choice.reserved45, out.reserved45);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED45;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved46:
    toRos_SubCauseCodeType(in.choice.reserved46, out.reserved46);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED46;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved47:
    toRos_SubCauseCodeType(in.choice.reserved47, out.reserved47);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED47;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved48:
    toRos_SubCauseCodeType(in.choice.reserved48, out.reserved48);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED48;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved49:
    toRos_SubCauseCodeType(in.choice.reserved49, out.reserved49);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED49;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved50:
    toRos_SubCauseCodeType(in.choice.reserved50, out.reserved50);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED50;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved51:
    toRos_SubCauseCodeType(in.choice.reserved51, out.reserved51);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED51;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved52:
    toRos_SubCauseCodeType(in.choice.reserved52, out.reserved52);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED52;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved53:
    toRos_SubCauseCodeType(in.choice.reserved53, out.reserved53);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED53;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved54:
    toRos_SubCauseCodeType(in.choice.reserved54, out.reserved54);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED54;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved55:
    toRos_SubCauseCodeType(in.choice.reserved55, out.reserved55);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED55;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved56:
    toRos_SubCauseCodeType(in.choice.reserved56, out.reserved56);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED56;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved57:
    toRos_SubCauseCodeType(in.choice.reserved57, out.reserved57);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED57;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved58:
    toRos_SubCauseCodeType(in.choice.reserved58, out.reserved58);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED58;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved59:
    toRos_SubCauseCodeType(in.choice.reserved59, out.reserved59);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED59;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved60:
    toRos_SubCauseCodeType(in.choice.reserved60, out.reserved60);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED60;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved61:
    toRos_SubCauseCodeType(in.choice.reserved61, out.reserved61);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED61;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved62:
    toRos_SubCauseCodeType(in.choice.reserved62, out.reserved62);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED62;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved63:
    toRos_SubCauseCodeType(in.choice.reserved63, out.reserved63);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED63;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved64:
    toRos_SubCauseCodeType(in.choice.reserved64, out.reserved64);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED64;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved65:
    toRos_SubCauseCodeType(in.choice.reserved65, out.reserved65);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED65;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved66:
    toRos_SubCauseCodeType(in.choice.reserved66, out.reserved66);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED66;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved67:
    toRos_SubCauseCodeType(in.choice.reserved67, out.reserved67);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED67;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved68:
    toRos_SubCauseCodeType(in.choice.reserved68, out.reserved68);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED68;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved69:
    toRos_SubCauseCodeType(in.choice.reserved69, out.reserved69);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED69;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved70:
    toRos_SubCauseCodeType(in.choice.reserved70, out.reserved70);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED70;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved71:
    toRos_SubCauseCodeType(in.choice.reserved71, out.reserved71);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED71;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved72:
    toRos_SubCauseCodeType(in.choice.reserved72, out.reserved72);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED72;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved73:
    toRos_SubCauseCodeType(in.choice.reserved73, out.reserved73);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED73;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved74:
    toRos_SubCauseCodeType(in.choice.reserved74, out.reserved74);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED74;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved75:
    toRos_SubCauseCodeType(in.choice.reserved75, out.reserved75);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED75;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved76:
    toRos_SubCauseCodeType(in.choice.reserved76, out.reserved76);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED76;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved77:
    toRos_SubCauseCodeType(in.choice.reserved77, out.reserved77);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED77;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved78:
    toRos_SubCauseCodeType(in.choice.reserved78, out.reserved78);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED78;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved79:
    toRos_SubCauseCodeType(in.choice.reserved79, out.reserved79);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED79;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved80:
    toRos_SubCauseCodeType(in.choice.reserved80, out.reserved80);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED80;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved81:
    toRos_SubCauseCodeType(in.choice.reserved81, out.reserved81);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED81;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved82:
    toRos_SubCauseCodeType(in.choice.reserved82, out.reserved82);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED82;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved83:
    toRos_SubCauseCodeType(in.choice.reserved83, out.reserved83);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED83;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved84:
    toRos_SubCauseCodeType(in.choice.reserved84, out.reserved84);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED84;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved85:
    toRos_SubCauseCodeType(in.choice.reserved85, out.reserved85);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED85;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved86:
    toRos_SubCauseCodeType(in.choice.reserved86, out.reserved86);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED86;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved87:
    toRos_SubCauseCodeType(in.choice.reserved87, out.reserved87);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED87;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved88:
    toRos_SubCauseCodeType(in.choice.reserved88, out.reserved88);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED88;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved89:
    toRos_SubCauseCodeType(in.choice.reserved89, out.reserved89);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED89;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved90:
    toRos_SubCauseCodeType(in.choice.reserved90, out.reserved90);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED90;
    break;
  case denm_ts_CauseCodeChoice_PR_vehicleBreakdown91:
    toRos_VehicleBreakdownSubCauseCode(in.choice.vehicleBreakdown91, out.vehicle_breakdown91);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_VEHICLE_BREAKDOWN91;
    break;
  case denm_ts_CauseCodeChoice_PR_postCrash92:
    toRos_PostCrashSubCauseCode(in.choice.postCrash92, out.post_crash92);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_POST_CRASH92;
    break;
  case denm_ts_CauseCodeChoice_PR_humanProblem93:
    toRos_HumanProblemSubCauseCode(in.choice.humanProblem93, out.human_problem93);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_HUMAN_PROBLEM93;
    break;
  case denm_ts_CauseCodeChoice_PR_stationaryVehicle94:
    toRos_StationaryVehicleSubCauseCode(in.choice.stationaryVehicle94, out.stationary_vehicle94);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_STATIONARY_VEHICLE94;
    break;
  case denm_ts_CauseCodeChoice_PR_emergencyVehicleApproaching95:
    toRos_EmergencyVehicleApproachingSubCauseCode(in.choice.emergencyVehicleApproaching95, out.emergency_vehicle_approaching95);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_EMERGENCY_VEHICLE_APPROACHING95;
    break;
  case denm_ts_CauseCodeChoice_PR_hazardousLocation_DangerousCurve96:
    toRos_HazardousLocationDangerousCurveSubCauseCode(in.choice.hazardousLocation_DangerousCurve96, out.hazardous_location_dangerous_curve96);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_HAZARDOUS_LOCATION_DANGEROUS_CURVE96;
    break;
  case denm_ts_CauseCodeChoice_PR_collisionRisk97:
    toRos_CollisionRiskSubCauseCode(in.choice.collisionRisk97, out.collision_risk97);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_COLLISION_RISK97;
    break;
  case denm_ts_CauseCodeChoice_PR_signalViolation98:
    toRos_SignalViolationSubCauseCode(in.choice.signalViolation98, out.signal_violation98);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_SIGNAL_VIOLATION98;
    break;
  case denm_ts_CauseCodeChoice_PR_dangerousSituation99:
    toRos_DangerousSituationSubCauseCode(in.choice.dangerousSituation99, out.dangerous_situation99);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_DANGEROUS_SITUATION99;
    break;
  case denm_ts_CauseCodeChoice_PR_railwayLevelCrossing100:
    toRos_RailwayLevelCrossingSubCauseCode(in.choice.railwayLevelCrossing100, out.railway_level_crossing100);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RAILWAY_LEVEL_CROSSING100;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved101:
    toRos_SubCauseCodeType(in.choice.reserved101, out.reserved101);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED101;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved102:
    toRos_SubCauseCodeType(in.choice.reserved102, out.reserved102);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED102;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved103:
    toRos_SubCauseCodeType(in.choice.reserved103, out.reserved103);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED103;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved104:
    toRos_SubCauseCodeType(in.choice.reserved104, out.reserved104);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED104;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved105:
    toRos_SubCauseCodeType(in.choice.reserved105, out.reserved105);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED105;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved106:
    toRos_SubCauseCodeType(in.choice.reserved106, out.reserved106);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED106;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved107:
    toRos_SubCauseCodeType(in.choice.reserved107, out.reserved107);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED107;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved108:
    toRos_SubCauseCodeType(in.choice.reserved108, out.reserved108);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED108;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved109:
    toRos_SubCauseCodeType(in.choice.reserved109, out.reserved109);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED109;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved110:
    toRos_SubCauseCodeType(in.choice.reserved110, out.reserved110);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED110;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved111:
    toRos_SubCauseCodeType(in.choice.reserved111, out.reserved111);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED111;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved112:
    toRos_SubCauseCodeType(in.choice.reserved112, out.reserved112);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED112;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved113:
    toRos_SubCauseCodeType(in.choice.reserved113, out.reserved113);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED113;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved114:
    toRos_SubCauseCodeType(in.choice.reserved114, out.reserved114);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED114;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved115:
    toRos_SubCauseCodeType(in.choice.reserved115, out.reserved115);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED115;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved116:
    toRos_SubCauseCodeType(in.choice.reserved116, out.reserved116);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED116;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved117:
    toRos_SubCauseCodeType(in.choice.reserved117, out.reserved117);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED117;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved118:
    toRos_SubCauseCodeType(in.choice.reserved118, out.reserved118);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED118;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved119:
    toRos_SubCauseCodeType(in.choice.reserved119, out.reserved119);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED119;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved120:
    toRos_SubCauseCodeType(in.choice.reserved120, out.reserved120);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED120;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved121:
    toRos_SubCauseCodeType(in.choice.reserved121, out.reserved121);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED121;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved122:
    toRos_SubCauseCodeType(in.choice.reserved122, out.reserved122);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED122;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved123:
    toRos_SubCauseCodeType(in.choice.reserved123, out.reserved123);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED123;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved124:
    toRos_SubCauseCodeType(in.choice.reserved124, out.reserved124);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED124;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved125:
    toRos_SubCauseCodeType(in.choice.reserved125, out.reserved125);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED125;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved126:
    toRos_SubCauseCodeType(in.choice.reserved126, out.reserved126);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED126;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved127:
    toRos_SubCauseCodeType(in.choice.reserved127, out.reserved127);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED127;
    break;
  case denm_ts_CauseCodeChoice_PR_reserved128:
    toRos_SubCauseCodeType(in.choice.reserved128, out.reserved128);
    out.choice = denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED128;
    break;
  default: break;
  }
}

void toStruct_CauseCodeChoice(const denm_ts_msgs::CauseCodeChoice& in, denm_ts_CauseCodeChoice_t& out) {
  memset(&out, 0, sizeof(denm_ts_CauseCodeChoice_t));
  switch (in.choice) {
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED0:
    toStruct_SubCauseCodeType(in.reserved0, out.choice.reserved0);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved0;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_TRAFFIC_CONDITION1:
    toStruct_TrafficConditionSubCauseCode(in.traffic_condition1, out.choice.trafficCondition1);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_trafficCondition1;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_ACCIDENT2:
    toStruct_AccidentSubCauseCode(in.accident2, out.choice.accident2);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_accident2;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_ROADWORKS3:
    toStruct_RoadworksSubCauseCode(in.roadworks3, out.choice.roadworks3);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_roadworks3;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED4:
    toStruct_SubCauseCodeType(in.reserved4, out.choice.reserved4);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved4;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_IMPASSABILITY5:
    toStruct_ImpassabilitySubCauseCode(in.impassability5, out.choice.impassability5);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_impassability5;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_ADVERSE_WEATHER_CONDITION_ADHESION6:
    toStruct_AdverseWeatherConditionAdhesionSubCauseCode(in.adverse_weather_condition_adhesion6, out.choice.adverseWeatherCondition_Adhesion6);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_adverseWeatherCondition_Adhesion6;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_AQUAPLANING7:
    toStruct_SubCauseCodeType(in.aquaplaning7, out.choice.aquaplaning7);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_aquaplaning7;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED8:
    toStruct_SubCauseCodeType(in.reserved8, out.choice.reserved8);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved8;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_HAZARDOUS_LOCATION_SURFACE_CONDITION9:
    toStruct_HazardousLocationSurfaceConditionSubCauseCode(in.hazardous_location_surface_condition9, out.choice.hazardousLocation_SurfaceCondition9);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_hazardousLocation_SurfaceCondition9;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_HAZARDOUS_LOCATION_OBSTACLE_ON_THE_ROAD10:
    toStruct_HazardousLocationObstacleOnTheRoadSubCauseCode(in.hazardous_location_obstacle_on_the_road10, out.choice.hazardousLocation_ObstacleOnTheRoad10);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_hazardousLocation_ObstacleOnTheRoad10;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_HAZARDOUS_LOCATION_ANIMAL_ON_THE_ROAD11:
    toStruct_HazardousLocationAnimalOnTheRoadSubCauseCode(in.hazardous_location_animal_on_the_road11, out.choice.hazardousLocation_AnimalOnTheRoad11);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_hazardousLocation_AnimalOnTheRoad11;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_HUMAN_PRESENCE_ON_THE_ROAD12:
    toStruct_HumanPresenceOnTheRoadSubCauseCode(in.human_presence_on_the_road12, out.choice.humanPresenceOnTheRoad12);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_humanPresenceOnTheRoad12;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED13:
    toStruct_SubCauseCodeType(in.reserved13, out.choice.reserved13);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved13;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_WRONG_WAY_DRIVING14:
    toStruct_WrongWayDrivingSubCauseCode(in.wrong_way_driving14, out.choice.wrongWayDriving14);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_wrongWayDriving14;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESCUE_AND_RECOVERY_WORK_IN_PROGRESS15:
    toStruct_RescueAndRecoveryWorkInProgressSubCauseCode(in.rescue_and_recovery_work_in_progress15, out.choice.rescueAndRecoveryWorkInProgress15);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_rescueAndRecoveryWorkInProgress15;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED16:
    toStruct_SubCauseCodeType(in.reserved16, out.choice.reserved16);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved16;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_ADVERSE_WEATHER_CONDITION_EXTREME_WEATHER_CONDITION17:
    toStruct_AdverseWeatherConditionExtremeWeatherConditionSubCauseCode(in.adverse_weather_condition_extreme_weather_condition17, out.choice.adverseWeatherCondition_ExtremeWeatherCondition17);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_adverseWeatherCondition_ExtremeWeatherCondition17;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_ADVERSE_WEATHER_CONDITION_VISIBILITY18:
    toStruct_AdverseWeatherConditionVisibilitySubCauseCode(in.adverse_weather_condition_visibility18, out.choice.adverseWeatherCondition_Visibility18);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_adverseWeatherCondition_Visibility18;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_ADVERSE_WEATHER_CONDITION_PRECIPITATION19:
    toStruct_AdverseWeatherConditionPrecipitationSubCauseCode(in.adverse_weather_condition_precipitation19, out.choice.adverseWeatherCondition_Precipitation19);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_adverseWeatherCondition_Precipitation19;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_VIOLENCE20:
    toStruct_SubCauseCodeType(in.violence20, out.choice.violence20);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_violence20;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED21:
    toStruct_SubCauseCodeType(in.reserved21, out.choice.reserved21);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved21;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED22:
    toStruct_SubCauseCodeType(in.reserved22, out.choice.reserved22);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved22;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED23:
    toStruct_SubCauseCodeType(in.reserved23, out.choice.reserved23);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved23;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED24:
    toStruct_SubCauseCodeType(in.reserved24, out.choice.reserved24);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved24;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED25:
    toStruct_SubCauseCodeType(in.reserved25, out.choice.reserved25);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved25;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_SLOW_VEHICLE26:
    toStruct_SlowVehicleSubCauseCode(in.slow_vehicle26, out.choice.slowVehicle26);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_slowVehicle26;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_DANGEROUS_END_OF_QUEUE27:
    toStruct_DangerousEndOfQueueSubCauseCode(in.dangerous_end_of_queue27, out.choice.dangerousEndOfQueue27);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_dangerousEndOfQueue27;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_PUBLIC_TRANSPORT_VEHICLE_APPROACHING28:
    toStruct_SubCauseCodeType(in.public_transport_vehicle_approaching28, out.choice.publicTransportVehicleApproaching28);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_publicTransportVehicleApproaching28;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED29:
    toStruct_SubCauseCodeType(in.reserved29, out.choice.reserved29);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved29;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED30:
    toStruct_SubCauseCodeType(in.reserved30, out.choice.reserved30);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved30;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED31:
    toStruct_SubCauseCodeType(in.reserved31, out.choice.reserved31);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved31;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED32:
    toStruct_SubCauseCodeType(in.reserved32, out.choice.reserved32);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved32;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED33:
    toStruct_SubCauseCodeType(in.reserved33, out.choice.reserved33);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved33;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED34:
    toStruct_SubCauseCodeType(in.reserved34, out.choice.reserved34);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved34;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED35:
    toStruct_SubCauseCodeType(in.reserved35, out.choice.reserved35);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved35;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED36:
    toStruct_SubCauseCodeType(in.reserved36, out.choice.reserved36);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved36;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED37:
    toStruct_SubCauseCodeType(in.reserved37, out.choice.reserved37);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved37;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED38:
    toStruct_SubCauseCodeType(in.reserved38, out.choice.reserved38);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved38;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED39:
    toStruct_SubCauseCodeType(in.reserved39, out.choice.reserved39);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved39;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED40:
    toStruct_SubCauseCodeType(in.reserved40, out.choice.reserved40);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved40;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED41:
    toStruct_SubCauseCodeType(in.reserved41, out.choice.reserved41);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved41;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED42:
    toStruct_SubCauseCodeType(in.reserved42, out.choice.reserved42);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved42;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED43:
    toStruct_SubCauseCodeType(in.reserved43, out.choice.reserved43);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved43;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED44:
    toStruct_SubCauseCodeType(in.reserved44, out.choice.reserved44);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved44;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED45:
    toStruct_SubCauseCodeType(in.reserved45, out.choice.reserved45);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved45;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED46:
    toStruct_SubCauseCodeType(in.reserved46, out.choice.reserved46);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved46;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED47:
    toStruct_SubCauseCodeType(in.reserved47, out.choice.reserved47);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved47;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED48:
    toStruct_SubCauseCodeType(in.reserved48, out.choice.reserved48);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved48;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED49:
    toStruct_SubCauseCodeType(in.reserved49, out.choice.reserved49);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved49;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED50:
    toStruct_SubCauseCodeType(in.reserved50, out.choice.reserved50);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved50;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED51:
    toStruct_SubCauseCodeType(in.reserved51, out.choice.reserved51);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved51;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED52:
    toStruct_SubCauseCodeType(in.reserved52, out.choice.reserved52);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved52;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED53:
    toStruct_SubCauseCodeType(in.reserved53, out.choice.reserved53);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved53;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED54:
    toStruct_SubCauseCodeType(in.reserved54, out.choice.reserved54);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved54;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED55:
    toStruct_SubCauseCodeType(in.reserved55, out.choice.reserved55);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved55;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED56:
    toStruct_SubCauseCodeType(in.reserved56, out.choice.reserved56);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved56;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED57:
    toStruct_SubCauseCodeType(in.reserved57, out.choice.reserved57);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved57;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED58:
    toStruct_SubCauseCodeType(in.reserved58, out.choice.reserved58);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved58;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED59:
    toStruct_SubCauseCodeType(in.reserved59, out.choice.reserved59);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved59;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED60:
    toStruct_SubCauseCodeType(in.reserved60, out.choice.reserved60);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved60;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED61:
    toStruct_SubCauseCodeType(in.reserved61, out.choice.reserved61);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved61;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED62:
    toStruct_SubCauseCodeType(in.reserved62, out.choice.reserved62);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved62;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED63:
    toStruct_SubCauseCodeType(in.reserved63, out.choice.reserved63);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved63;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED64:
    toStruct_SubCauseCodeType(in.reserved64, out.choice.reserved64);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved64;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED65:
    toStruct_SubCauseCodeType(in.reserved65, out.choice.reserved65);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved65;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED66:
    toStruct_SubCauseCodeType(in.reserved66, out.choice.reserved66);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved66;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED67:
    toStruct_SubCauseCodeType(in.reserved67, out.choice.reserved67);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved67;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED68:
    toStruct_SubCauseCodeType(in.reserved68, out.choice.reserved68);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved68;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED69:
    toStruct_SubCauseCodeType(in.reserved69, out.choice.reserved69);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved69;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED70:
    toStruct_SubCauseCodeType(in.reserved70, out.choice.reserved70);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved70;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED71:
    toStruct_SubCauseCodeType(in.reserved71, out.choice.reserved71);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved71;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED72:
    toStruct_SubCauseCodeType(in.reserved72, out.choice.reserved72);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved72;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED73:
    toStruct_SubCauseCodeType(in.reserved73, out.choice.reserved73);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved73;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED74:
    toStruct_SubCauseCodeType(in.reserved74, out.choice.reserved74);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved74;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED75:
    toStruct_SubCauseCodeType(in.reserved75, out.choice.reserved75);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved75;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED76:
    toStruct_SubCauseCodeType(in.reserved76, out.choice.reserved76);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved76;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED77:
    toStruct_SubCauseCodeType(in.reserved77, out.choice.reserved77);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved77;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED78:
    toStruct_SubCauseCodeType(in.reserved78, out.choice.reserved78);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved78;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED79:
    toStruct_SubCauseCodeType(in.reserved79, out.choice.reserved79);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved79;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED80:
    toStruct_SubCauseCodeType(in.reserved80, out.choice.reserved80);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved80;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED81:
    toStruct_SubCauseCodeType(in.reserved81, out.choice.reserved81);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved81;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED82:
    toStruct_SubCauseCodeType(in.reserved82, out.choice.reserved82);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved82;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED83:
    toStruct_SubCauseCodeType(in.reserved83, out.choice.reserved83);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved83;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED84:
    toStruct_SubCauseCodeType(in.reserved84, out.choice.reserved84);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved84;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED85:
    toStruct_SubCauseCodeType(in.reserved85, out.choice.reserved85);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved85;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED86:
    toStruct_SubCauseCodeType(in.reserved86, out.choice.reserved86);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved86;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED87:
    toStruct_SubCauseCodeType(in.reserved87, out.choice.reserved87);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved87;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED88:
    toStruct_SubCauseCodeType(in.reserved88, out.choice.reserved88);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved88;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED89:
    toStruct_SubCauseCodeType(in.reserved89, out.choice.reserved89);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved89;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED90:
    toStruct_SubCauseCodeType(in.reserved90, out.choice.reserved90);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved90;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_VEHICLE_BREAKDOWN91:
    toStruct_VehicleBreakdownSubCauseCode(in.vehicle_breakdown91, out.choice.vehicleBreakdown91);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_vehicleBreakdown91;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_POST_CRASH92:
    toStruct_PostCrashSubCauseCode(in.post_crash92, out.choice.postCrash92);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_postCrash92;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_HUMAN_PROBLEM93:
    toStruct_HumanProblemSubCauseCode(in.human_problem93, out.choice.humanProblem93);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_humanProblem93;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_STATIONARY_VEHICLE94:
    toStruct_StationaryVehicleSubCauseCode(in.stationary_vehicle94, out.choice.stationaryVehicle94);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_stationaryVehicle94;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_EMERGENCY_VEHICLE_APPROACHING95:
    toStruct_EmergencyVehicleApproachingSubCauseCode(in.emergency_vehicle_approaching95, out.choice.emergencyVehicleApproaching95);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_emergencyVehicleApproaching95;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_HAZARDOUS_LOCATION_DANGEROUS_CURVE96:
    toStruct_HazardousLocationDangerousCurveSubCauseCode(in.hazardous_location_dangerous_curve96, out.choice.hazardousLocation_DangerousCurve96);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_hazardousLocation_DangerousCurve96;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_COLLISION_RISK97:
    toStruct_CollisionRiskSubCauseCode(in.collision_risk97, out.choice.collisionRisk97);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_collisionRisk97;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_SIGNAL_VIOLATION98:
    toStruct_SignalViolationSubCauseCode(in.signal_violation98, out.choice.signalViolation98);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_signalViolation98;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_DANGEROUS_SITUATION99:
    toStruct_DangerousSituationSubCauseCode(in.dangerous_situation99, out.choice.dangerousSituation99);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_dangerousSituation99;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RAILWAY_LEVEL_CROSSING100:
    toStruct_RailwayLevelCrossingSubCauseCode(in.railway_level_crossing100, out.choice.railwayLevelCrossing100);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_railwayLevelCrossing100;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED101:
    toStruct_SubCauseCodeType(in.reserved101, out.choice.reserved101);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved101;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED102:
    toStruct_SubCauseCodeType(in.reserved102, out.choice.reserved102);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved102;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED103:
    toStruct_SubCauseCodeType(in.reserved103, out.choice.reserved103);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved103;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED104:
    toStruct_SubCauseCodeType(in.reserved104, out.choice.reserved104);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved104;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED105:
    toStruct_SubCauseCodeType(in.reserved105, out.choice.reserved105);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved105;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED106:
    toStruct_SubCauseCodeType(in.reserved106, out.choice.reserved106);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved106;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED107:
    toStruct_SubCauseCodeType(in.reserved107, out.choice.reserved107);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved107;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED108:
    toStruct_SubCauseCodeType(in.reserved108, out.choice.reserved108);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved108;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED109:
    toStruct_SubCauseCodeType(in.reserved109, out.choice.reserved109);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved109;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED110:
    toStruct_SubCauseCodeType(in.reserved110, out.choice.reserved110);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved110;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED111:
    toStruct_SubCauseCodeType(in.reserved111, out.choice.reserved111);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved111;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED112:
    toStruct_SubCauseCodeType(in.reserved112, out.choice.reserved112);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved112;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED113:
    toStruct_SubCauseCodeType(in.reserved113, out.choice.reserved113);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved113;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED114:
    toStruct_SubCauseCodeType(in.reserved114, out.choice.reserved114);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved114;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED115:
    toStruct_SubCauseCodeType(in.reserved115, out.choice.reserved115);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved115;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED116:
    toStruct_SubCauseCodeType(in.reserved116, out.choice.reserved116);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved116;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED117:
    toStruct_SubCauseCodeType(in.reserved117, out.choice.reserved117);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved117;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED118:
    toStruct_SubCauseCodeType(in.reserved118, out.choice.reserved118);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved118;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED119:
    toStruct_SubCauseCodeType(in.reserved119, out.choice.reserved119);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved119;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED120:
    toStruct_SubCauseCodeType(in.reserved120, out.choice.reserved120);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved120;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED121:
    toStruct_SubCauseCodeType(in.reserved121, out.choice.reserved121);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved121;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED122:
    toStruct_SubCauseCodeType(in.reserved122, out.choice.reserved122);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved122;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED123:
    toStruct_SubCauseCodeType(in.reserved123, out.choice.reserved123);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved123;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED124:
    toStruct_SubCauseCodeType(in.reserved124, out.choice.reserved124);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved124;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED125:
    toStruct_SubCauseCodeType(in.reserved125, out.choice.reserved125);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved125;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED126:
    toStruct_SubCauseCodeType(in.reserved126, out.choice.reserved126);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved126;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED127:
    toStruct_SubCauseCodeType(in.reserved127, out.choice.reserved127);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved127;
    break;
  case denm_ts_msgs::CauseCodeChoice::CHOICE_RESERVED128:
    toStruct_SubCauseCodeType(in.reserved128, out.choice.reserved128);
    out.present = denm_ts_CauseCodeChoice_PR::denm_ts_CauseCodeChoice_PR_reserved128;
    break;
  default: break;
  }
}

}
