/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF is an alternative representation of the cause code value of a traffic event. 
 *
 * It shall include the following components: 
 *
 * @field ccAndScc: the main cause of a detected event. Each entry is of a different type and represents the sub cause code.

 * The semantics of the entire DF are completely defined by the choice value which represents the cause code value. 
 * The interpretation of the sub cause code value may provide additional information that is not strictly necessary to understand 
 * the cause code itself, and is therefore optional.
 *
 * @category: Traffic information
 * @revision: Created in V2.1.1, description amended in V2.2.1
 *
CauseCodeV2 ::= SEQUENCE {
    ccAndScc    CauseCodeChoice,
    ...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_CauseCodeV2.h>
#include <etsi_its_denm_ts_conversion/convertCauseCodeChoice.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/CauseCodeV2.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/cause_code_v2.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_CauseCodeV2(const denm_ts_CauseCodeV2_t& in, denm_ts_msgs::CauseCodeV2& out) {
  toRos_CauseCodeChoice(in.ccAndScc, out.cc_and_scc);
}

void toStruct_CauseCodeV2(const denm_ts_msgs::CauseCodeV2& in, denm_ts_CauseCodeV2_t& out) {
  memset(&out, 0, sizeof(denm_ts_CauseCodeV2_t));
  toStruct_CauseCodeChoice(in.cc_and_scc, out.ccAndScc);
}

}
