/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF provides a description of dangerous goods being carried by a heavy vehicle.
 *
 * It shall include the following components: 
 * 
 * @field dangerousGoodsType: Type of dangerous goods.
 * 
 * @field unNumber: a 4-digit number that identifies the substance of the dangerous goods as specified in
 * United Nations Recommendations on the Transport of Dangerous Goods - Model Regulations [4],
 * 
 * @field elevatedTemperature: whether the carried dangerous goods are transported at high temperature.
 * If yes, the value shall be set to TRUE,
 * 
 * @field tunnelsRestricted: whether the heavy vehicle carrying dangerous goods is restricted to enter tunnels.
 * If yes, the value shall be set to TRUE,
 * 
 * @field limitedQuantity: whether the carried dangerous goods are packed with limited quantity.
 * If yes, the value shall be set to TRUE,
 * 
 * @field emergencyActionCode: physical signage placard at the vehicle that carries information on how an emergency
 * service should deal with an incident. This component is optional; it shall be present if the information is available.
 * 
 * @field phoneNumber: contact phone number of assistance service in case of incident or accident.
 * This component is optional, it shall be present if the information is available.
 * 
 * @field companyName: name of company that manages the transportation of the dangerous goods.
 * This component is optional; it shall be present if the information is available.
 * 
 * @category Vehicle information
 * @revision: V1.3.1
 *
DangerousGoodsExtended ::= SEQUENCE {
    dangerousGoodsType      DangerousGoodsBasic,
    unNumber                INTEGER (0..9999),
    elevatedTemperature     BOOLEAN,
    tunnelsRestricted       BOOLEAN,
    limitedQuantity         BOOLEAN,
    emergencyActionCode     IA5String (SIZE (1..24)) OPTIONAL,
    phoneNumber             PhoneNumber OPTIONAL,
    companyName             UTF8String (SIZE (1..24)) OPTIONAL,
    ...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_DangerousGoodsExtended.h>
#include <etsi_its_denm_ts_coding/BOOLEAN.h>
#include <etsi_its_primitives_conversion/convertBOOLEAN.h>
#include <etsi_its_denm_ts_conversion/convertDangerousGoodsBasic.h>
#include <etsi_its_denm_ts_coding/IA5String.h>
#include <etsi_its_primitives_conversion/convertIA5String.h>
#include <etsi_its_denm_ts_coding/INTEGER.h>
#include <etsi_its_primitives_conversion/convertINTEGER.h>
#include <etsi_its_denm_ts_conversion/convertPhoneNumber.h>
#include <etsi_its_denm_ts_coding/UTF8String.h>
#include <etsi_its_primitives_conversion/convertUTF8String.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/DangerousGoodsExtended.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/dangerous_goods_extended.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_DangerousGoodsExtended(const denm_ts_DangerousGoodsExtended_t& in, denm_ts_msgs::DangerousGoodsExtended& out) {
  toRos_DangerousGoodsBasic(in.dangerousGoodsType, out.dangerous_goods_type);
  etsi_its_primitives_conversion::toRos_INTEGER(in.unNumber, out.un_number);
  etsi_its_primitives_conversion::toRos_BOOLEAN(in.elevatedTemperature, out.elevated_temperature);
  etsi_its_primitives_conversion::toRos_BOOLEAN(in.tunnelsRestricted, out.tunnels_restricted);
  etsi_its_primitives_conversion::toRos_BOOLEAN(in.limitedQuantity, out.limited_quantity);
  if (in.emergencyActionCode) {
    etsi_its_primitives_conversion::toRos_IA5String(*in.emergencyActionCode, out.emergency_action_code);
    out.emergency_action_code_is_present = true;
  }
  if (in.phoneNumber) {
    toRos_PhoneNumber(*in.phoneNumber, out.phone_number);
    out.phone_number_is_present = true;
  }
  if (in.companyName) {
    etsi_its_primitives_conversion::toRos_UTF8String(*in.companyName, out.company_name);
    out.company_name_is_present = true;
  }
}

void toStruct_DangerousGoodsExtended(const denm_ts_msgs::DangerousGoodsExtended& in, denm_ts_DangerousGoodsExtended_t& out) {
  memset(&out, 0, sizeof(denm_ts_DangerousGoodsExtended_t));
  toStruct_DangerousGoodsBasic(in.dangerous_goods_type, out.dangerousGoodsType);
  etsi_its_primitives_conversion::toStruct_INTEGER(in.un_number, out.unNumber);
  etsi_its_primitives_conversion::toStruct_BOOLEAN(in.elevated_temperature, out.elevatedTemperature);
  etsi_its_primitives_conversion::toStruct_BOOLEAN(in.tunnels_restricted, out.tunnelsRestricted);
  etsi_its_primitives_conversion::toStruct_BOOLEAN(in.limited_quantity, out.limitedQuantity);
  if (in.emergency_action_code_is_present) {
    out.emergencyActionCode = (IA5String_t*) calloc(1, sizeof(IA5String_t));
    etsi_its_primitives_conversion::toStruct_IA5String(in.emergency_action_code, *out.emergencyActionCode);
  }
  if (in.phone_number_is_present) {
    out.phoneNumber = (denm_ts_PhoneNumber_t*) calloc(1, sizeof(denm_ts_PhoneNumber_t));
    toStruct_PhoneNumber(in.phone_number, *out.phoneNumber);
  }
  if (in.company_name_is_present) {
    out.companyName = (UTF8String_t*) calloc(1, sizeof(UTF8String_t));
    etsi_its_primitives_conversion::toStruct_UTF8String(in.company_name, *out.companyName);
  }
}

}
