/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This type represents the DENM payload.
 *
 * It shall include the following components: 
 *
 * @field management: the Management Container.
 *
 * @field situation: the optional Situation Container.
 *
 * @field location: the optional Location Container.
 *
 * @field alacarte: the optional ALaCarte Container .
 *
*
DenmPayload ::= SEQUENCE {
    management ManagementContainer,
    situation  SituationContainer OPTIONAL,
    location   LocationContainer OPTIONAL,
    alacarte   AlacarteContainer OPTIONAL
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_DenmPayload.h>
#include <etsi_its_denm_ts_conversion/convertAlacarteContainer.h>
#include <etsi_its_denm_ts_conversion/convertLocationContainer.h>
#include <etsi_its_denm_ts_conversion/convertManagementContainer.h>
#include <etsi_its_denm_ts_conversion/convertSituationContainer.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/DenmPayload.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/denm_payload.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_DenmPayload(const denm_ts_DenmPayload_t& in, denm_ts_msgs::DenmPayload& out) {
  toRos_ManagementContainer(in.management, out.management);
  if (in.situation) {
    toRos_SituationContainer(*in.situation, out.situation);
    out.situation_is_present = true;
  }
  if (in.location) {
    toRos_LocationContainer(*in.location, out.location);
    out.location_is_present = true;
  }
  if (in.alacarte) {
    toRos_AlacarteContainer(*in.alacarte, out.alacarte);
    out.alacarte_is_present = true;
  }
}

void toStruct_DenmPayload(const denm_ts_msgs::DenmPayload& in, denm_ts_DenmPayload_t& out) {
  memset(&out, 0, sizeof(denm_ts_DenmPayload_t));
  toStruct_ManagementContainer(in.management, out.management);
  if (in.situation_is_present) {
    out.situation = (denm_ts_SituationContainer_t*) calloc(1, sizeof(denm_ts_SituationContainer_t));
    toStruct_SituationContainer(in.situation, *out.situation);
  }
  if (in.location_is_present) {
    out.location = (denm_ts_LocationContainer_t*) calloc(1, sizeof(denm_ts_LocationContainer_t));
    toStruct_LocationContainer(in.location, *out.location);
  }
  if (in.alacarte_is_present) {
    out.alacarte = (denm_ts_AlacarteContainer_t*) calloc(1, sizeof(denm_ts_AlacarteContainer_t));
    toStruct_AlacarteContainer(in.alacarte, *out.alacarte);
  }
}

}
