/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF provides information related to an event at a defined position.
 *
 * It shall include the following components: 
 * 
 * @field eventPosition: offset position of a detected event point to a defined position. 
 * 
 * @field eventDeltaTime: optional time travelled by the detecting ITS-S since the previous detected event point.
 * 
 * @field informationQuality: Information quality of the detection for this event point.
 * 
 * @category: GeoReference information, Traffic information
 * @revision: generalized the semantics in V2.1.1
 *
EventPoint ::= SEQUENCE {
    eventPosition         DeltaReferencePosition,
    eventDeltaTime        PathDeltaTime OPTIONAL,
    informationQuality    InformationQuality
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_EventPoint.h>
#include <etsi_its_denm_ts_conversion/convertDeltaReferencePosition.h>
#include <etsi_its_denm_ts_conversion/convertInformationQuality.h>
#include <etsi_its_denm_ts_conversion/convertPathDeltaTime.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/EventPoint.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/event_point.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_EventPoint(const denm_ts_EventPoint_t& in, denm_ts_msgs::EventPoint& out) {
  toRos_DeltaReferencePosition(in.eventPosition, out.event_position);
  if (in.eventDeltaTime) {
    toRos_PathDeltaTime(*in.eventDeltaTime, out.event_delta_time);
    out.event_delta_time_is_present = true;
  }
  toRos_InformationQuality(in.informationQuality, out.information_quality);
}

void toStruct_EventPoint(const denm_ts_msgs::EventPoint& in, denm_ts_EventPoint_t& out) {
  memset(&out, 0, sizeof(denm_ts_EventPoint_t));
  toStruct_DeltaReferencePosition(in.event_position, out.eventPosition);
  if (in.event_delta_time_is_present) {
    out.eventDeltaTime = (denm_ts_PathDeltaTime_t*) calloc(1, sizeof(denm_ts_PathDeltaTime_t));
    toStruct_PathDeltaTime(in.event_delta_time, *out.eventDeltaTime);
  }
  toStruct_InformationQuality(in.information_quality, out.informationQuality);
}

}
