/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF represents the top-level DF to represent a lane position. A lane position is a transversal position on the carriageway at a specific longitudinal position, in resolution of lanes of the carriageway.
 *
 * @note: This DF is the most general way to represent a lane position: it provides a complete set of information regarding a transversal (dimensionless) position on the carriageway at a specific 
 * reference position, i.e. it provides different options and synonyms to represent the lane at which the reference position (the point) is located. A confidence is used to describe the probability 
 * that the object is located in the provided lane. The dimension of the object or extension of an area are not considered: See @ref OccupiedLanesWithConfidence for describing the occupation of lanes, 
 * where the dimensions of an object or the extension of an area is considered.
 *
 * It shall include the following components: 
 *
 * @field lanePositionBased: lane position information for a defined reference position.
 * 
 * @field mapBased: optional lane position information described in the context of a MAPEM as specified in ETSI TS 103 301 [15]. 
 * If present, it shall describe the same reference position using the lane identification in the MAPEM. This component can be used only if a MAPEM is available for the reference position 
 * (e.g. on an intersection): In this case it is used as a synonym to the mandatory component lanePositionBased. 
 * 
 * @field confidence: confidence information for expressing the probability that the object is located at the indicated lane.  
 * If the value of the component lanePositionBased is generated directly from the absolute reference position and reference topology information, 
 * no sensor shall be indicated in the component usedDetectionInformation of the @ref MetaInformation.
 *
 * @category: Road Topology information
 * @revision: newly created in V2.2.1. The previous DF GeneralizedLanePosition is now renamed to @ref LanePositionOptions. 
 *
GeneralizedLanePosition ::= SEQUENCE {
    lanePositionBased     LanePositionOptions,
    mapBased              MapPosition OPTIONAL,
    confidence            MetaInformation,
    ... 
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_GeneralizedLanePosition.h>
#include <etsi_its_denm_ts_conversion/convertLanePositionOptions.h>
#include <etsi_its_denm_ts_conversion/convertMapPosition.h>
#include <etsi_its_denm_ts_conversion/convertMetaInformation.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/GeneralizedLanePosition.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/generalized_lane_position.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_GeneralizedLanePosition(const denm_ts_GeneralizedLanePosition_t& in, denm_ts_msgs::GeneralizedLanePosition& out) {
  toRos_LanePositionOptions(in.lanePositionBased, out.lane_position_based);
  if (in.mapBased) {
    toRos_MapPosition(*in.mapBased, out.map_based);
    out.map_based_is_present = true;
  }
  toRos_MetaInformation(in.confidence, out.confidence);
}

void toStruct_GeneralizedLanePosition(const denm_ts_msgs::GeneralizedLanePosition& in, denm_ts_GeneralizedLanePosition_t& out) {
  memset(&out, 0, sizeof(denm_ts_GeneralizedLanePosition_t));
  toStruct_LanePositionOptions(in.lane_position_based, out.lanePositionBased);
  if (in.map_based_is_present) {
    out.mapBased = (denm_ts_MapPosition_t*) calloc(1, sizeof(denm_ts_MapPosition_t));
    toStruct_MapPosition(in.map_based, *out.mapBased);
  }
  toStruct_MetaInformation(in.confidence, out.confidence);
}

}
