/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DE represents the value of the sub cause code of the @ref CauseCode `hazardousLocation-SurfaceCondition`. 
 * 
The value shall be set to:
 * - 0  - `unavailable`     - in case further detailed information on the road surface condition is unavailable,
 * - 1  - `rockfalls`       - in case rock falls are detected on the road surface,
 * - 2  - `earthquakeDamage`- in case the road surface is damaged by earthquake,
 * - 3  - `sewerCollapse`   - in case of sewer collapse on the road surface,
 * - 4  - `subsidence`      - in case road surface is damaged by subsidence,
 * - 5  - `snowDrifts`      - in case road surface is damaged due to snow drift,
 * - 6  - `stormDamage`     - in case road surface is damaged by strong storm,
 * - 7  - `burstPipe`       - in case road surface is damaged due to pipe burst,
 * - 8  - `volcanoEruption` - in case road surface is damaged due to volcano eruption,
 * - 9  - `fallingIce`      - in case road surface damage is due to falling ice,
 * - 10 - `fire`            - in case there is fire on or near to the road surface.
 * - 11-255                 - are reserved for future usage.
 *
 * @category: Traffic information
 * @revision: V1.3.1
 *
HazardousLocation-SurfaceConditionSubCauseCode ::= INTEGER {
    unavailable      (0), 
    rockfalls        (1), 
    earthquakeDamage (2), 
    sewerCollapse    (3), 
    subsidence       (4), 
    snowDrifts       (5), 
    stormDamage      (6), 
    burstPipe        (7), 
    volcanoEruption  (8), 
    fallingIce       (9), 
    fire             (10)
} (0..255)
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_HazardousLocation-SurfaceConditionSubCauseCode.h>
#include <etsi_its_denm_ts_coding/INTEGER.h>
#include <etsi_its_primitives_conversion/convertINTEGER.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/HazardousLocationSurfaceConditionSubCauseCode.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/hazardous_location_surface_condition_sub_cause_code.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_HazardousLocationSurfaceConditionSubCauseCode(const denm_ts_HazardousLocation_SurfaceConditionSubCauseCode_t& in, denm_ts_msgs::HazardousLocationSurfaceConditionSubCauseCode& out) {
  etsi_its_primitives_conversion::toRos_INTEGER(in, out.value);
}

void toStruct_HazardousLocationSurfaceConditionSubCauseCode(const denm_ts_msgs::HazardousLocationSurfaceConditionSubCauseCode& in, denm_ts_HazardousLocation_SurfaceConditionSubCauseCode_t& out) {
  memset(&out, 0, sizeof(denm_ts_HazardousLocation_SurfaceConditionSubCauseCode_t));
  etsi_its_primitives_conversion::toStruct_INTEGER(in.value, out);
}

}
