/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This type contains detailed information about the vehicle in which the originating ITS-S is mounted, for mitigating the consequences 
 * of a collision.
 *
 * It shall include the following components: 
 *
 * @field heightLonCarrLeft: the height of the left longitudinal carrier of the vehicle from base to top.
 *
 * @field heightLonCarrRight: the height of the right longitudinal carrier of the vehicle from base to top.
 *
 * @field posLonCarrLeft: the position of the left longitudinal carrier of vehicle.
 *
 * @field posLonCarrRight: the position of the right longitudinal carrier of vehicle.
 *
 * @field positionOfPillars: information about the vertical support of the vehicle in which the originating ITS-S is mounted. It shall be 
 * included for passenger vehicles only.
 *
 * @field posCentMass: the position of the centre of mass of the vehicle.
 *
 * @field wheelBaseVehicle: the wheel base of the vehicle.
 *
 * @field turningRadius: the turning radius of the vehicle.
 *
 * @field posFrontAx: the position of the front axle of the vehicle.
 *
 * @field positionOfOccupants: indicates whether an in-vehicle seat is occupied at the moment of generation of the message.
 *
 * @field vehicleMass: the mass of the unloaded vehicle
 *
 * @field requestResponseIndication: indicates whether the originating ITS-S transmitting the impactReduction component is requesting 
 * the receiving ITS-S to provide also its impactReduction component.
 *
*
ImpactReductionContainer ::= SEQUENCE {
    heightLonCarrLeft         HeightLonCarr,
    heightLonCarrRight        HeightLonCarr,
    posLonCarrLeft            PosLonCarr,
    posLonCarrRight           PosLonCarr,
    positionOfPillars         PositionOfPillars,
    posCentMass               PosCentMass,
    wheelBaseVehicle          WheelBaseVehicle,
    turningRadius             TurningRadius,
    posFrontAx                PosFrontAx,
    positionOfOccupants       PositionOfOccupants,
    vehicleMass               VehicleMass,
    requestResponseIndication RequestResponseIndication
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_ImpactReductionContainer.h>
#include <etsi_its_denm_ts_conversion/convertHeightLonCarr.h>
#include <etsi_its_denm_ts_conversion/convertPosCentMass.h>
#include <etsi_its_denm_ts_conversion/convertPosFrontAx.h>
#include <etsi_its_denm_ts_conversion/convertPosLonCarr.h>
#include <etsi_its_denm_ts_conversion/convertPositionOfOccupants.h>
#include <etsi_its_denm_ts_conversion/convertPositionOfPillars.h>
#include <etsi_its_denm_ts_conversion/convertRequestResponseIndication.h>
#include <etsi_its_denm_ts_conversion/convertTurningRadius.h>
#include <etsi_its_denm_ts_conversion/convertVehicleMass.h>
#include <etsi_its_denm_ts_conversion/convertWheelBaseVehicle.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/ImpactReductionContainer.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/impact_reduction_container.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_ImpactReductionContainer(const denm_ts_ImpactReductionContainer_t& in, denm_ts_msgs::ImpactReductionContainer& out) {
  toRos_HeightLonCarr(in.heightLonCarrLeft, out.height_lon_carr_left);
  toRos_HeightLonCarr(in.heightLonCarrRight, out.height_lon_carr_right);
  toRos_PosLonCarr(in.posLonCarrLeft, out.pos_lon_carr_left);
  toRos_PosLonCarr(in.posLonCarrRight, out.pos_lon_carr_right);
  toRos_PositionOfPillars(in.positionOfPillars, out.position_of_pillars);
  toRos_PosCentMass(in.posCentMass, out.pos_cent_mass);
  toRos_WheelBaseVehicle(in.wheelBaseVehicle, out.wheel_base_vehicle);
  toRos_TurningRadius(in.turningRadius, out.turning_radius);
  toRos_PosFrontAx(in.posFrontAx, out.pos_front_ax);
  toRos_PositionOfOccupants(in.positionOfOccupants, out.position_of_occupants);
  toRos_VehicleMass(in.vehicleMass, out.vehicle_mass);
  toRos_RequestResponseIndication(in.requestResponseIndication, out.request_response_indication);
}

void toStruct_ImpactReductionContainer(const denm_ts_msgs::ImpactReductionContainer& in, denm_ts_ImpactReductionContainer_t& out) {
  memset(&out, 0, sizeof(denm_ts_ImpactReductionContainer_t));
  toStruct_HeightLonCarr(in.height_lon_carr_left, out.heightLonCarrLeft);
  toStruct_HeightLonCarr(in.height_lon_carr_right, out.heightLonCarrRight);
  toStruct_PosLonCarr(in.pos_lon_carr_left, out.posLonCarrLeft);
  toStruct_PosLonCarr(in.pos_lon_carr_right, out.posLonCarrRight);
  toStruct_PositionOfPillars(in.position_of_pillars, out.positionOfPillars);
  toStruct_PosCentMass(in.pos_cent_mass, out.posCentMass);
  toStruct_WheelBaseVehicle(in.wheel_base_vehicle, out.wheelBaseVehicle);
  toStruct_TurningRadius(in.turning_radius, out.turningRadius);
  toStruct_PosFrontAx(in.pos_front_ax, out.posFrontAx);
  toStruct_PositionOfOccupants(in.position_of_occupants, out.positionOfOccupants);
  toStruct_VehicleMass(in.vehicle_mass, out.vehicleMass);
  toStruct_RequestResponseIndication(in.request_response_indication, out.requestResponseIndication);
}

}
