/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DE represents the value of the sub cause codes of the @ref CauseCode `impassability`
 * 
 * The value shall be set to:
 * - 0 `unavailable`              - in case further detailed information about the unmanaged road blockage is unavailable,
 * - 1 `flooding          `       - in case the road is affected by flooding,
 * - 2 `dangerOfAvalanches`       - in case the road is at risk of being affected or blocked by avalanches,
 * - 3 `blastingOfAvalanches`     - in case there is an active blasting of avalanches on or near the road,
 * - 4 `landslips`                - in case the road is affected by landslips,
 * - 5 `chemicalSpillage`         - in case the road is affected by chemical spillage,
 * - 6 `winterClosure`            - in case the road is impassable due to a winter closure.
 * - 7 `sinkhole`                 - in case the road is impassable due to large holes in the road surface.
 * - 8 `earthquakeDamage`         - in case the road is obstructed or partially obstructed because of damage caused by an earthquake.
 * - 9 `fallenTrees`              - in case the road is obstructed or partially obstructed by one or more fallen trees. 
 * - 10 `rockfalls`               - in case the road is obstructed or partially obstructed due to fallen rocks.
 * - 11 `sewerOverflow`           - in case the road is obstructed or partially obstructed by overflows from one or more sewers. 
 * - 12 `stormDamage`             - in case the road is obstructed or partially obstructed by debris caused by strong winds.
 * - 13 `subsidence`              - in case the road surface has sunken or collapsed in places.
 * - 14 `burstPipe`               - in case the road surface has sunken or collapsed in places due to burst pipes.
 * - 15 `burstWaterMain`          - in case the road is obstructed due to local flooding and/or subsidence. 
 * - 16 `fallenPowerCables`       - in case the road is obstructed or partly obstructed by one or more fallen power cables.
 * - 17 `snowDrifts`              - in case the road is obstructed or partially obstructed by snow drifting in progress or patches of deep snow due to earlier drifting.
 * - 15-255                       - are reserved for future usage.
 *
 * @category: Traffic information
 * @revision: Created in V2.2.1
*
ImpassabilitySubCauseCode ::= INTEGER {
    unavailable               (0), 
    flooding                  (1),
    dangerOfAvalanches        (2), 
    blastingOfAvalanches      (3), 
    landslips                 (4), 
    chemicalSpillage          (5),
    winterClosure             (6),
    sinkhole                  (7),
    earthquakeDamage          (8),
    fallenTrees               (9),
    rockfalls                 (10),
    sewerOverflow             (11),
    stormDamage               (12),
    subsidence                (13),
    burstPipe                 (14),
    burstWaterMain            (15),
    fallenPowerCables         (16),
    snowDrifts                (17)
} (0..255)
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_ImpassabilitySubCauseCode.h>
#include <etsi_its_denm_ts_coding/INTEGER.h>
#include <etsi_its_primitives_conversion/convertINTEGER.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/ImpassabilitySubCauseCode.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/impassability_sub_cause_code.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_ImpassabilitySubCauseCode(const denm_ts_ImpassabilitySubCauseCode_t& in, denm_ts_msgs::ImpassabilitySubCauseCode& out) {
  etsi_its_primitives_conversion::toRos_INTEGER(in, out.value);
}

void toStruct_ImpassabilitySubCauseCode(const denm_ts_msgs::ImpassabilitySubCauseCode& in, denm_ts_ImpassabilitySubCauseCode_t& out) {
  memset(&out, 0, sizeof(denm_ts_ImpassabilitySubCauseCode_t));
  etsi_its_primitives_conversion::toStruct_INTEGER(in.value, out);
}

}
