/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DE indicates a transversal position on the carriageway at a specific longitudinal position, in resolution of lanes of the carriageway. 
 *
 * For right-hand traffic roads, the value shall be set to:
 * - `-1` if the position is off, i.e. besides the road,
 * - `0` if the position is on the inner hard shoulder, i.e. the hard should adjacent to the leftmost lane,
 * - `n` (`n > 0` and `n < 14`), if the position is on the n-th driving lane counted from the leftmost lane to the rightmost lane of a specific traffic direction,
 * - `14` if the position is on the outer hard shoulder, i.e. the hard should adjacent to rightmost lane (if present).
 *
 * For left-hand traffic roads, the value shall be set to:
 * - `-1` if the position is off, i.e. besides the road,
 * - `0` if the position is on the inner hard shoulder, i.e. the hard should adjacent to the rightmost lane,
 * - `n` (`n > 0` and `n < 14`), if the position is on the n-th driving lane counted from the rightmost lane to the leftmost lane of a specific traffic direction,
 * - `14` if the position is on the outer hard shoulder, i.e. the hard should adjacent to leftmost lane (if present).
 *
 *  @note: in practice this means that the position is counted from "inside" to "outside" no matter which traffic practice is used.
 *
 * If the carriageway allows only traffic in one direction (e.g. in case of dual or multiple carriageway roads), the position is counted from the physical border of the carriageway. 
 * If the carriageway allows traffic in both directions and there is no physical delimitation between traffic directions (e.g. on a single carrriageway road), 
 * the position is counted from the legal (i.e. optical) separation between traffic directions (horizontal marking). 
 *
 * If not indicated otherwise (by lane markings or traffic signs), the legal separation on carriageways allowing traffic on both directions is identified as follows:
 * - If the total number of lanes N is even, the lanes are divided evenly between the traffic directions starting from the outside of the carriageway on both sides and the 
 *   imaginary separation between traffic directions is on the border between the even number of lanes N/2.
 * - If the total number of lanes N is odd, the lanes are divided evenly between traffic direction starting from the outside of the carriageway on both sides. 
 *   The remaining middle lane is assigned to both traffic directions as innermost lane.
 *
 * @category: Road topology information
 * @revision: Description of the legal separation of carriageways added in V2.2.1
*
LanePosition ::= INTEGER {
    offTheRoad           (-1), 
    innerHardShoulder    (0), 
    outerHardShoulder    (14) 
} (-1..14)
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_LanePosition.h>
#include <etsi_its_denm_ts_coding/INTEGER.h>
#include <etsi_its_primitives_conversion/convertINTEGER.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/LanePosition.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/lane_position.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_LanePosition(const denm_ts_LanePosition_t& in, denm_ts_msgs::LanePosition& out) {
  etsi_its_primitives_conversion::toRos_INTEGER(in, out.value);
}

void toStruct_LanePosition(const denm_ts_msgs::LanePosition& in, denm_ts_LanePosition_t& out) {
  memset(&out, 0, sizeof(denm_ts_LanePosition_t));
  etsi_its_primitives_conversion::toStruct_INTEGER(in.value, out);
}

}
