/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF represents a set of options to describe a lane position and is the second level DF to represent a lane position. The top-level DFs are @ref GeneralizedLanePosition or @ref OccupiedLanesWithConfidence. 
 * A lane position is a transversal position on the carriageway at a specific longitudinal position, in resolution of lanes of the carriageway.
 *
 * The following options are available:
 *
 * @field simplelanePosition: a single lane position without any additional context information.
 *
 * @field simpleLaneType: a lane type, to be used when the lane position is unknown but the type of lane is known. This can be used in scenarios where a certain confidence about the used lane type is given 
 * but no or limited knowledge about the absolute lane number is available. For example, a cyclist on a cycle-lane or vehicles on a specific lane that is unique for the part of the road (e.g. a bus lane).
 * 
 * @field detailedlanePosition: a single lane position with additional lane details.
 * 
 * @field lanePositionWithLateralDetails: a single lane position with additional details and the lateral position within the lane.
 *
 * @field trafficIslandPosition: a position on a traffic island, i.e. between two lanes. 
 *
 * @category: Road Topology information
 * @revision: Created in V2.2.1 from the DF GeneralizedLanePosition of V2.1.1. 
 *
LanePositionOptions ::= CHOICE {
    simplelanePosition                   LanePosition,
    simpleLaneType                       LaneType,
    detailedlanePosition                 LanePositionAndType,
    lanePositionWithLateralDetails       LanePositionWithLateralDetails,
    trafficIslandPosition                TrafficIslandPosition,
    ...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_LanePositionOptions.h>
#include <etsi_its_denm_ts_conversion/convertLanePosition.h>
#include <etsi_its_denm_ts_conversion/convertLanePositionAndType.h>
#include <etsi_its_denm_ts_conversion/convertLanePositionWithLateralDetails.h>
#include <etsi_its_denm_ts_conversion/convertLaneType.h>
#include <etsi_its_denm_ts_conversion/convertTrafficIslandPosition.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/LanePositionOptions.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/lane_position_options.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_LanePositionOptions(const denm_ts_LanePositionOptions_t& in, denm_ts_msgs::LanePositionOptions& out) {
  switch (in.present) {
  case denm_ts_LanePositionOptions_PR_simplelanePosition:
    toRos_LanePosition(in.choice.simplelanePosition, out.simplelane_position);
    out.choice = denm_ts_msgs::LanePositionOptions::CHOICE_SIMPLELANE_POSITION;
    break;
  case denm_ts_LanePositionOptions_PR_simpleLaneType:
    toRos_LaneType(in.choice.simpleLaneType, out.simple_lane_type);
    out.choice = denm_ts_msgs::LanePositionOptions::CHOICE_SIMPLE_LANE_TYPE;
    break;
  case denm_ts_LanePositionOptions_PR_detailedlanePosition:
    toRos_LanePositionAndType(in.choice.detailedlanePosition, out.detailedlane_position);
    out.choice = denm_ts_msgs::LanePositionOptions::CHOICE_DETAILEDLANE_POSITION;
    break;
  case denm_ts_LanePositionOptions_PR_lanePositionWithLateralDetails:
    toRos_LanePositionWithLateralDetails(in.choice.lanePositionWithLateralDetails, out.lane_position_with_lateral_details);
    out.choice = denm_ts_msgs::LanePositionOptions::CHOICE_LANE_POSITION_WITH_LATERAL_DETAILS;
    break;
  case denm_ts_LanePositionOptions_PR_trafficIslandPosition:
    toRos_TrafficIslandPosition(in.choice.trafficIslandPosition, out.traffic_island_position);
    out.choice = denm_ts_msgs::LanePositionOptions::CHOICE_TRAFFIC_ISLAND_POSITION;
    break;
  default: break;
  }
}

void toStruct_LanePositionOptions(const denm_ts_msgs::LanePositionOptions& in, denm_ts_LanePositionOptions_t& out) {
  memset(&out, 0, sizeof(denm_ts_LanePositionOptions_t));
  switch (in.choice) {
  case denm_ts_msgs::LanePositionOptions::CHOICE_SIMPLELANE_POSITION:
    toStruct_LanePosition(in.simplelane_position, out.choice.simplelanePosition);
    out.present = denm_ts_LanePositionOptions_PR::denm_ts_LanePositionOptions_PR_simplelanePosition;
    break;
  case denm_ts_msgs::LanePositionOptions::CHOICE_SIMPLE_LANE_TYPE:
    toStruct_LaneType(in.simple_lane_type, out.choice.simpleLaneType);
    out.present = denm_ts_LanePositionOptions_PR::denm_ts_LanePositionOptions_PR_simpleLaneType;
    break;
  case denm_ts_msgs::LanePositionOptions::CHOICE_DETAILEDLANE_POSITION:
    toStruct_LanePositionAndType(in.detailedlane_position, out.choice.detailedlanePosition);
    out.present = denm_ts_LanePositionOptions_PR::denm_ts_LanePositionOptions_PR_detailedlanePosition;
    break;
  case denm_ts_msgs::LanePositionOptions::CHOICE_LANE_POSITION_WITH_LATERAL_DETAILS:
    toStruct_LanePositionWithLateralDetails(in.lane_position_with_lateral_details, out.choice.lanePositionWithLateralDetails);
    out.present = denm_ts_LanePositionOptions_PR::denm_ts_LanePositionOptions_PR_lanePositionWithLateralDetails;
    break;
  case denm_ts_msgs::LanePositionOptions::CHOICE_TRAFFIC_ISLAND_POSITION:
    toStruct_TrafficIslandPosition(in.traffic_island_position, out.choice.trafficIslandPosition);
    out.present = denm_ts_LanePositionOptions_PR::denm_ts_LanePositionOptions_PR_trafficIslandPosition;
    break;
  default: break;
  }
}

}
