/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This type represents the Management Container.
 *
 * It shall include the following components: 
 *
 * @field actionId: the identifier of the DENM.
 *
 * @field detectionTime: the time at which the event is detected.
 *
 * @field referenceTime: the time at which a new DENM, an update DENM or a cancellation DENM is generated
 *
 * @field termination: the optional termination type of the DENM.
 *
 * @field eventPosition: the geographical position used in the definition of the awareness area / relevance zone, see clause 6.1.3.
 *
 * @field awarenessDistance: the optional radius of the circular awareness area, with centre at the event position or at any of the 
 * event history points as defined in clause 6.1.3.1.
 *
 * @field trafficDirection: the optional traffic direction along which the receiving ITS-S may encounter the event, 
 * as defined in clause 6.1.3.
 *
 * @field validityDuration: the validity duration of a DENM. This component represents a time offset in the unit of second since detectionTime.
 *
 * @field transmissionInterval: the optional time interval for DENM transmission as defined by the originating ITS-S. 
 * If the component is not present in DENM, a default value defaultValidity is assumed.
 *
 * @field stationType: the station type information of the originating ITS-S.
 *
*
ManagementContainer ::= SEQUENCE {
    actionId                  ActionId,
    detectionTime             TimestampIts,
    referenceTime             TimestampIts,
    termination               Termination OPTIONAL,
    eventPosition             ReferencePosition,
    awarenessDistance         StandardLength3b OPTIONAL,
    trafficDirection          TrafficDirection OPTIONAL,
    validityDuration          DeltaTimeSecond DEFAULT defaultValidity, 
    transmissionInterval      DeltaTimeMilliSecondPositive OPTIONAL,
    stationType               StationType,
    ...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_ManagementContainer.h>
#include <etsi_its_denm_ts_conversion/convertActionId.h>
#include <etsi_its_denm_ts_conversion/convertDeltaTimeMilliSecondPositive.h>
#include <etsi_its_denm_ts_conversion/convertDeltaTimeSecond.h>
#include <etsi_its_denm_ts_conversion/convertReferencePosition.h>
#include <etsi_its_denm_ts_conversion/convertStandardLength3b.h>
#include <etsi_its_denm_ts_conversion/convertStationType.h>
#include <etsi_its_denm_ts_conversion/convertTermination.h>
#include <etsi_its_denm_ts_conversion/convertTimestampIts.h>
#include <etsi_its_denm_ts_conversion/convertTrafficDirection.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/ManagementContainer.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/management_container.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_ManagementContainer(const denm_ts_ManagementContainer_t& in, denm_ts_msgs::ManagementContainer& out) {
  toRos_ActionId(in.actionId, out.action_id);
  toRos_TimestampIts(in.detectionTime, out.detection_time);
  toRos_TimestampIts(in.referenceTime, out.reference_time);
  if (in.termination) {
    toRos_Termination(*in.termination, out.termination);
    out.termination_is_present = true;
  }
  toRos_ReferencePosition(in.eventPosition, out.event_position);
  if (in.awarenessDistance) {
    toRos_StandardLength3b(*in.awarenessDistance, out.awareness_distance);
    out.awareness_distance_is_present = true;
  }
  if (in.trafficDirection) {
    toRos_TrafficDirection(*in.trafficDirection, out.traffic_direction);
    out.traffic_direction_is_present = true;
  }
  if (in.validityDuration) {
    toRos_DeltaTimeSecond(*in.validityDuration, out.validity_duration);
  }
  if (in.transmissionInterval) {
    toRos_DeltaTimeMilliSecondPositive(*in.transmissionInterval, out.transmission_interval);
    out.transmission_interval_is_present = true;
  }
  toRos_StationType(in.stationType, out.station_type);
}

void toStruct_ManagementContainer(const denm_ts_msgs::ManagementContainer& in, denm_ts_ManagementContainer_t& out) {
  memset(&out, 0, sizeof(denm_ts_ManagementContainer_t));
  toStruct_ActionId(in.action_id, out.actionId);
  toStruct_TimestampIts(in.detection_time, out.detectionTime);
  toStruct_TimestampIts(in.reference_time, out.referenceTime);
  if (in.termination_is_present) {
    out.termination = (denm_ts_Termination_t*) calloc(1, sizeof(denm_ts_Termination_t));
    toStruct_Termination(in.termination, *out.termination);
  }
  toStruct_ReferencePosition(in.event_position, out.eventPosition);
  if (in.awareness_distance_is_present) {
    out.awarenessDistance = (denm_ts_StandardLength3b_t*) calloc(1, sizeof(denm_ts_StandardLength3b_t));
    toStruct_StandardLength3b(in.awareness_distance, *out.awarenessDistance);
  }
  if (in.traffic_direction_is_present) {
    out.trafficDirection = (denm_ts_TrafficDirection_t*) calloc(1, sizeof(denm_ts_TrafficDirection_t));
    toStruct_TrafficDirection(in.traffic_direction, *out.trafficDirection);
  }
  out.validityDuration = (denm_ts_DeltaTimeSecond_t*) calloc(1, sizeof(denm_ts_DeltaTimeSecond_t));
  toStruct_DeltaTimeSecond(in.validity_duration, *out.validityDuration);
  if (in.transmission_interval_is_present) {
    out.transmissionInterval = (denm_ts_DeltaTimeMilliSecondPositive_t*) calloc(1, sizeof(denm_ts_DeltaTimeMilliSecondPositive_t));
    toStruct_DeltaTimeMilliSecondPositive(in.transmission_interval, *out.transmissionInterval);
  }
  toStruct_StationType(in.station_type, out.stationType);
}

}
