/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DF provides references to an element described in a MAPEM according to ETSI TS 103 301 [i.15], such as a lane or connection at a specific intersection or road segment. 
 * 
 * It shall include the following components: 
 * 
 * @field mapReference: the optional reference to a MAPEM that describes the intersection or road segment. It is absent if the MAPEM topology is known from the context.
 * 
 * @field laneIds: the optional list of the identifiers of the lanes to be referenced. 
 * 
 * @field connectionIds: the optional list of the identifiers of the connections to be referenced. 
 *
 * @category: Road topology information
 * @revision: Created in V2.2.1
*
MapemElementReference::= SEQUENCE {
  mapReference      MapReference OPTIONAL,
  laneIds           MapemLaneList  OPTIONAL,
  connectionIds	    MapemConnectionList  OPTIONAL,		
  ...
} 
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_MapemElementReference.h>
#include <etsi_its_denm_ts_conversion/convertMapReference.h>
#include <etsi_its_denm_ts_conversion/convertMapemConnectionList.h>
#include <etsi_its_denm_ts_conversion/convertMapemLaneList.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/MapemElementReference.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/mapem_element_reference.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_MapemElementReference(const denm_ts_MapemElementReference_t& in, denm_ts_msgs::MapemElementReference& out) {
  if (in.mapReference) {
    toRos_MapReference(*in.mapReference, out.map_reference);
    out.map_reference_is_present = true;
  }
  if (in.laneIds) {
    toRos_MapemLaneList(*in.laneIds, out.lane_ids);
    out.lane_ids_is_present = true;
  }
  if (in.connectionIds) {
    toRos_MapemConnectionList(*in.connectionIds, out.connection_ids);
    out.connection_ids_is_present = true;
  }
}

void toStruct_MapemElementReference(const denm_ts_msgs::MapemElementReference& in, denm_ts_MapemElementReference_t& out) {
  memset(&out, 0, sizeof(denm_ts_MapemElementReference_t));
  if (in.map_reference_is_present) {
    out.mapReference = (denm_ts_MapReference_t*) calloc(1, sizeof(denm_ts_MapReference_t));
    toStruct_MapReference(in.map_reference, *out.mapReference);
  }
  if (in.lane_ids_is_present) {
    out.laneIds = (denm_ts_MapemLaneList_t*) calloc(1, sizeof(denm_ts_MapemLaneList_t));
    toStruct_MapemLaneList(in.lane_ids, *out.laneIds);
  }
  if (in.connection_ids_is_present) {
    out.connectionIds = (denm_ts_MapemConnectionList_t*) calloc(1, sizeof(denm_ts_MapemConnectionList_t));
    toStruct_MapemConnectionList(in.connection_ids, *out.connectionIds);
  }
}

}
