/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DF indicates both the class and associated subclass that best describes an object.
 *
 * The following options are available:
 *
 * @field vehicleSubClass: the object is a road vehicle and the specific subclass is specified.
 *
 * @field vruSubClass: the object is a VRU and the specific subclass is specified.
 *
 * @field groupSubClass: the object is a VRU group or cluster and the cluster information is specified.
 *
 * @field otherSubClass: the object is of a different type than the above and the specific subclass is specified.
 *
 * @category: Sensing information
 * @revision: Created in V2.1.1
 *
ObjectClass ::= CHOICE {
    vehicleSubClass      TrafficParticipantType (unknown|passengerCar..tram|agricultural),
    vruSubClass          VruProfileAndSubprofile,
    groupSubClass        VruClusterInformation 
    (WITH COMPONENTS{..., clusterBoundingBoxShape ABSENT}),
    otherSubClass        OtherSubClass,
    ...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_ObjectClass.h>
#include <etsi_its_denm_ts_conversion/convertOtherSubClass.h>
#include <etsi_its_denm_ts_conversion/convertTrafficParticipantType.h>
#include <etsi_its_denm_ts_conversion/convertVruClusterInformation.h>
#include <etsi_its_denm_ts_conversion/convertVruProfileAndSubprofile.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/ObjectClass.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/object_class.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_ObjectClass(const denm_ts_ObjectClass_t& in, denm_ts_msgs::ObjectClass& out) {
  switch (in.present) {
  case denm_ts_ObjectClass_PR_vehicleSubClass:
    toRos_TrafficParticipantType(in.choice.vehicleSubClass, out.vehicle_sub_class);
    out.choice = denm_ts_msgs::ObjectClass::CHOICE_VEHICLE_SUB_CLASS;
    break;
  case denm_ts_ObjectClass_PR_vruSubClass:
    toRos_VruProfileAndSubprofile(in.choice.vruSubClass, out.vru_sub_class);
    out.choice = denm_ts_msgs::ObjectClass::CHOICE_VRU_SUB_CLASS;
    break;
  case denm_ts_ObjectClass_PR_groupSubClass:
    toRos_VruClusterInformation(in.choice.groupSubClass, out.group_sub_class);
    out.choice = denm_ts_msgs::ObjectClass::CHOICE_GROUP_SUB_CLASS;
    break;
  case denm_ts_ObjectClass_PR_otherSubClass:
    toRos_OtherSubClass(in.choice.otherSubClass, out.other_sub_class);
    out.choice = denm_ts_msgs::ObjectClass::CHOICE_OTHER_SUB_CLASS;
    break;
  default: break;
  }
}

void toStruct_ObjectClass(const denm_ts_msgs::ObjectClass& in, denm_ts_ObjectClass_t& out) {
  memset(&out, 0, sizeof(denm_ts_ObjectClass_t));
  switch (in.choice) {
  case denm_ts_msgs::ObjectClass::CHOICE_VEHICLE_SUB_CLASS:
    toStruct_TrafficParticipantType(in.vehicle_sub_class, out.choice.vehicleSubClass);
    out.present = denm_ts_ObjectClass_PR::denm_ts_ObjectClass_PR_vehicleSubClass;
    break;
  case denm_ts_msgs::ObjectClass::CHOICE_VRU_SUB_CLASS:
    toStruct_VruProfileAndSubprofile(in.vru_sub_class, out.choice.vruSubClass);
    out.present = denm_ts_ObjectClass_PR::denm_ts_ObjectClass_PR_vruSubClass;
    break;
  case denm_ts_msgs::ObjectClass::CHOICE_GROUP_SUB_CLASS:
    toStruct_VruClusterInformation(in.group_sub_class, out.choice.groupSubClass);
    out.present = denm_ts_ObjectClass_PR::denm_ts_ObjectClass_PR_groupSubClass;
    break;
  case denm_ts_msgs::ObjectClass::CHOICE_OTHER_SUB_CLASS:
    toStruct_OtherSubClass(in.other_sub_class, out.choice.otherSubClass);
    out.present = denm_ts_ObjectClass_PR::denm_ts_ObjectClass_PR_otherSubClass;
    break;
  default: break;
  }
}

}
