/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DF represents a dimension of an object together with a confidence value.
 *
 * It shall include the following components: 
 * 
 * @field value: the object dimension value which can be estimated as the mean of the current distribution.
 *
 * @field confidence: the associated confidence value.
 *
 * @category: Sensing information
 * @revision: Created in V2.1.1
*
ObjectDimension ::= SEQUENCE {
    value         ObjectDimensionValue,
    confidence    ObjectDimensionConfidence
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_ObjectDimension.h>
#include <etsi_its_denm_ts_conversion/convertObjectDimensionConfidence.h>
#include <etsi_its_denm_ts_conversion/convertObjectDimensionValue.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/ObjectDimension.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/object_dimension.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_ObjectDimension(const denm_ts_ObjectDimension_t& in, denm_ts_msgs::ObjectDimension& out) {
  toRos_ObjectDimensionValue(in.value, out.value);
  toRos_ObjectDimensionConfidence(in.confidence, out.confidence);
}

void toStruct_ObjectDimension(const denm_ts_msgs::ObjectDimension& in, denm_ts_ObjectDimension_t& out) {
  memset(&out, 0, sizeof(denm_ts_ObjectDimension_t));
  toStruct_ObjectDimensionValue(in.value, out.value);
  toStruct_ObjectDimensionConfidence(in.confidence, out.confidence);
}

}
