/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DE indicates the face or part of a face of a solid object.
 *
 * The object is modelled  as a rectangular prism that has a length that is greater than its width, with the faces of the object being defined as:
 * - front: the face defined by the prism's width and height, and which is the first face in direction of longitudinal movement of the object,
 * - back: the face defined by the prism's width and height, and which is the last face in direction of longitudinal movement of the object,
 * - side: the faces defined by the prism's length and height with "left" and "right" defined by looking at the front face and "front" and "back" defined w.r.t to the front and back faces. 
 *
 * Note: It is permissible to derive the required object dimensions and orientation from models to provide a best guess.
 * 
 * @category: Basic information
 * @revision: V2.1.1
*
ObjectFace ::= ENUMERATED {
    front          (0), 
    sideLeftFront  (1), 
    sideLeftBack   (2), 
    sideRightFront (3), 
    sideRightBack  (4),
    back           (5)   
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_ObjectFace.h>

#ifdef ROS1
#include <etsi_its_denm_ts_msgs/ObjectFace.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/object_face.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_ObjectFace(const denm_ts_ObjectFace_t& in, denm_ts_msgs::ObjectFace& out) {
  out.value = in;
}

void toStruct_ObjectFace(const denm_ts_msgs::ObjectFace& in, denm_ts_ObjectFace_t& out) {
  memset(&out, 0, sizeof(denm_ts_ObjectFace_t));
  out = in.value;
}

}
