/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF represents a set of lanes which are partially or fully occupied by an object or event at an externally defined reference position. 
 *
 * @note: In contrast to @ref GeneralizedLanePosition, the dimension of the object or event area (width and length) is taken into account to determine the occupancy, 
 * i.e. this DF describes the lanes which are blocked by an object or event and not the position of the object / event itself. A confidence is used to describe the 
 * probability that exactly all the provided lanes are occupied. 
 *
 * It shall include the following components: 
 *
 * @field lanePositionBased: a set of up to `4` lanes that are partially or fully occupied by an object or event, ordered by increasing value of @ref LanePosition. 
 * Lanes that are partially occupied can be described using the component lanePositionWithLateralDetails of @ref  Options, with the following constraints: 
 * The distance to lane borders which are covered by the object / event shall be set to 0. Only the distances to the leftmost and/or rightmost border which are not covered by 
 * the object / event shall be provided with values > 0. Those values shall be added to the respective instances of @ref LanePositionOptions, i.e. the first entry shall contain the component distanceToLeftBorder > 0 , 
 * and/or the last entry shall contain the component distanceToRightBorder > 0; the respective other components of these entries shall be set to 0.
 * 
 * @field mapBased: optional lane information described in the context of a MAPEM as specified in ETSI TS 103 301 [15]. 
 * If present, it shall describe the same lane(s) as listed in the component lanePositionBased, but using the lane identification of the MAPEM. This component can be used only if a 
 * MAPEM is available for the reference position (e.g. on an intersection): In this case it is used as a synonym to the mandatory component lanePositionBased. 
 *
 * @field confidence: mandatory confidence information for expressing the probability that all the provided lanes are occupied. It also provides information on how the lane 
 * information were generated. If none of the sensors were used, the lane information is assumed to be derived directly from the absolute reference position and the related dimension.
 *
 * @category: Road Topology information
 * @revision: Created in V2.2.1
 *
OccupiedLanesWithConfidence::= SEQUENCE {
    lanePositionBased     SEQUENCE (SIZE(1..4)) OF LanePositionOptions,
    mapBased              SEQUENCE (SIZE(1..4)) OF MapPosition  OPTIONAL,
    confidence            MetaInformation,
    ... 
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_OccupiedLanesWithConfidence.h>
#include <etsi_its_denm_ts_conversion/convertLanePositionOptions.h>
#include <etsi_its_denm_ts_conversion/convertMapPosition.h>
#include <etsi_its_denm_ts_conversion/convertMetaInformation.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/OccupiedLanesWithConfidence.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/occupied_lanes_with_confidence.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_OccupiedLanesWithConfidence(const denm_ts_OccupiedLanesWithConfidence_t& in, denm_ts_msgs::OccupiedLanesWithConfidence& out) {
  for (int i = 0; i < in.lanePositionBased.list.count; ++i) {
    denm_ts_msgs::LanePositionOptions el;
    toRos_LanePositionOptions(*(in.lanePositionBased.list.array[i]), el);
    out.lane_position_based.push_back(el);
  }
  if (in.mapBased) {
    for (int i = 0; i < in.mapBased->list.count; ++i) {
      denm_ts_msgs::MapPosition el;
      toRos_MapPosition(*(in.mapBased->list.array[i]), el);
      out.map_based.push_back(el);
    }
    out.map_based_is_present = true;
  }
  toRos_MetaInformation(in.confidence, out.confidence);
}

void toStruct_OccupiedLanesWithConfidence(const denm_ts_msgs::OccupiedLanesWithConfidence& in, denm_ts_OccupiedLanesWithConfidence_t& out) {
  memset(&out, 0, sizeof(denm_ts_OccupiedLanesWithConfidence_t));
    for (int i = 0; i < in.lane_position_based.size(); ++i) {
      denm_ts_LanePositionOptions_t* el = (denm_ts_LanePositionOptions_t*) calloc(1, sizeof(denm_ts_LanePositionOptions_t));
      toStruct_LanePositionOptions(in.lane_position_based[i], *el);
      if (asn_sequence_add(&out.lanePositionBased, el)) throw std::invalid_argument("Failed to add to A_SEQUENCE_OF");
    }
  if (in.map_based_is_present) {
    for (int i = 0; i < in.map_based.size(); ++i) {
      denm_ts_MapPosition_t* el = (denm_ts_MapPosition_t*) calloc(1, sizeof(denm_ts_MapPosition_t));
      toStruct_MapPosition(in.map_based[i], *el);
      if (asn_sequence_add(&out.mapBased, el)) throw std::invalid_argument("Failed to add to A_SEQUENCE_OF");
    }
  }
  toStruct_MetaInformation(in.confidence, out.confidence);
}

}
