/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF defines a predicted offset position that can be used within a predicted path or trajectory, together with optional data to describe a path zone shape.
 *
 * It shall include the following components: 
 *
 * @field deltaLatitude: the offset latitude with regards to a pre-defined reference position. 
 *
 * @field deltaLongitude: the offset longitude with regards to a pre-defined reference position. 
 * 
 * @field horizontalPositionConfidence: the optional confidence value associated to the horizontal geographical position.
 *
 * @field deltaAltitude: the optional offset altitude with regards to a pre-defined reference position, with default value unavailable. 
 *
 * @field altitudeConfidence: the optional confidence value associated to the altitude value of the geographical position, with default value unavailable.
 * 
 * @field pathDeltaTime: the optional travel time to the waypoint from the predefined reference position.

 * @field symmetricAreaOffset: the optional symmetric offset to generate a shape, see Annex D for details.
 *  
 * @field asymmetricAreaOffset: the optional asymmetric offset to generate a shape, see Annex D for details. 
 *
 * @category GeoReference information
 * @revision: Created in V2.1.1, type of pathDeltaTime changed and optionality added, fields symmetricAreaOffset and asymmetricAreaOffset added in V2.2.1
 *
PathPointPredicted::= SEQUENCE {
  deltaLatitude                 DeltaLatitude,      
  deltaLongitude                DeltaLongitude, 
  horizontalPositionConfidence  PosConfidenceEllipse OPTIONAL,   
  deltaAltitude                 DeltaAltitude DEFAULT unavailable, 
  altitudeConfidence            AltitudeConfidence DEFAULT unavailable,
  pathDeltaTime                 PathDeltaTimeChoice OPTIONAL,
  symmetricAreaOffset           StandardLength9b OPTIONAL, 
  asymmetricAreaOffset          StandardLength9b OPTIONAL, 
  ... 
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_PathPointPredicted.h>
#include <etsi_its_denm_ts_conversion/convertAltitudeConfidence.h>
#include <etsi_its_denm_ts_conversion/convertDeltaAltitude.h>
#include <etsi_its_denm_ts_conversion/convertDeltaLatitude.h>
#include <etsi_its_denm_ts_conversion/convertDeltaLongitude.h>
#include <etsi_its_denm_ts_conversion/convertPathDeltaTimeChoice.h>
#include <etsi_its_denm_ts_conversion/convertPosConfidenceEllipse.h>
#include <etsi_its_denm_ts_conversion/convertStandardLength9b.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/PathPointPredicted.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/path_point_predicted.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_PathPointPredicted(const denm_ts_PathPointPredicted_t& in, denm_ts_msgs::PathPointPredicted& out) {
  toRos_DeltaLatitude(in.deltaLatitude, out.delta_latitude);
  toRos_DeltaLongitude(in.deltaLongitude, out.delta_longitude);
  if (in.horizontalPositionConfidence) {
    toRos_PosConfidenceEllipse(*in.horizontalPositionConfidence, out.horizontal_position_confidence);
    out.horizontal_position_confidence_is_present = true;
  }
  if (in.deltaAltitude) {
    toRos_DeltaAltitude(*in.deltaAltitude, out.delta_altitude);
  }
  if (in.altitudeConfidence) {
    toRos_AltitudeConfidence(*in.altitudeConfidence, out.altitude_confidence);
  }
  if (in.pathDeltaTime) {
    toRos_PathDeltaTimeChoice(*in.pathDeltaTime, out.path_delta_time);
    out.path_delta_time_is_present = true;
  }
  if (in.symmetricAreaOffset) {
    toRos_StandardLength9b(*in.symmetricAreaOffset, out.symmetric_area_offset);
    out.symmetric_area_offset_is_present = true;
  }
  if (in.asymmetricAreaOffset) {
    toRos_StandardLength9b(*in.asymmetricAreaOffset, out.asymmetric_area_offset);
    out.asymmetric_area_offset_is_present = true;
  }
}

void toStruct_PathPointPredicted(const denm_ts_msgs::PathPointPredicted& in, denm_ts_PathPointPredicted_t& out) {
  memset(&out, 0, sizeof(denm_ts_PathPointPredicted_t));
  toStruct_DeltaLatitude(in.delta_latitude, out.deltaLatitude);
  toStruct_DeltaLongitude(in.delta_longitude, out.deltaLongitude);
  if (in.horizontal_position_confidence_is_present) {
    out.horizontalPositionConfidence = (denm_ts_PosConfidenceEllipse_t*) calloc(1, sizeof(denm_ts_PosConfidenceEllipse_t));
    toStruct_PosConfidenceEllipse(in.horizontal_position_confidence, *out.horizontalPositionConfidence);
  }
  out.deltaAltitude = (denm_ts_DeltaAltitude_t*) calloc(1, sizeof(denm_ts_DeltaAltitude_t));
  toStruct_DeltaAltitude(in.delta_altitude, *out.deltaAltitude);
  out.altitudeConfidence = (denm_ts_AltitudeConfidence_t*) calloc(1, sizeof(denm_ts_AltitudeConfidence_t));
  toStruct_AltitudeConfidence(in.altitude_confidence, *out.altitudeConfidence);
  if (in.path_delta_time_is_present) {
    out.pathDeltaTime = (denm_ts_PathDeltaTimeChoice_t*) calloc(1, sizeof(denm_ts_PathDeltaTimeChoice_t));
    toStruct_PathDeltaTimeChoice(in.path_delta_time, *out.pathDeltaTime);
  }
  if (in.symmetric_area_offset_is_present) {
    out.symmetricAreaOffset = (denm_ts_StandardLength9b_t*) calloc(1, sizeof(denm_ts_StandardLength9b_t));
    toStruct_StandardLength9b(in.symmetric_area_offset, *out.symmetricAreaOffset);
  }
  if (in.asymmetric_area_offset_is_present) {
    out.asymmetricAreaOffset = (denm_ts_StandardLength9b_t*) calloc(1, sizeof(denm_ts_StandardLength9b_t));
    toStruct_StandardLength9b(in.asymmetric_area_offset, *out.asymmetricAreaOffset);
  }
}

}
