/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DF represents a predicted path, predicted trajectory or predicted path zone together with usage information and a prediction confidence.
 *
 * It shall include the following components: 
 *
 * @field pathPredicted: the predicted path (pathDeltaTime ABSENT) or trajectory (pathDeltaTime PRESENT) and/or the path zone (symmetricAreaOffset PRESENT).
 *
 * @field usageIndication: an indication of how the predicted path will be used. 
 *
 * @field confidenceLevel: the confidence that the path/trajectory in pathPredicted will occur as predicted.
 *
 * @category: GeoReference information
 * @revision: created in V2.2.1
 *
PathPredicted2::= SEQUENCE{
    pathPredicted     PathPredicted
   ((WITH COMPONENT (WITH COMPONENTS {..., pathDeltaTime ABSENT, symmetricAreaOffset ABSENT})) |
    (WITH COMPONENT (WITH COMPONENTS {..., pathDeltaTime PRESENT, symmetricAreaOffset ABSENT})) |
    (WITH COMPONENT (WITH COMPONENTS {..., pathDeltaTime ABSENT, symmetricAreaOffset PRESENT})) |
    (WITH COMPONENT (WITH COMPONENTS {..., pathDeltaTime PRESENT, symmetricAreaOffset PRESENT}))),
    usageIndication   UsageIndication,
    confidenceLevel   ConfidenceLevel,   
    ...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_PathPredicted2.h>
#include <etsi_its_denm_ts_conversion/convertConfidenceLevel.h>
#include <etsi_its_denm_ts_conversion/convertPathPredicted.h>
#include <etsi_its_denm_ts_conversion/convertUsageIndication.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/PathPredicted2.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/path_predicted2.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_PathPredicted2(const denm_ts_PathPredicted2_t& in, denm_ts_msgs::PathPredicted2& out) {
  toRos_PathPredicted(in.pathPredicted, out.path_predicted);
  toRos_UsageIndication(in.usageIndication, out.usage_indication);
  toRos_ConfidenceLevel(in.confidenceLevel, out.confidence_level);
}

void toStruct_PathPredicted2(const denm_ts_msgs::PathPredicted2& in, denm_ts_PathPredicted2_t& out) {
  memset(&out, 0, sizeof(denm_ts_PathPredicted2_t));
  toStruct_PathPredicted(in.path_predicted, out.pathPredicted);
  toStruct_UsageIndication(in.usage_indication, out.usageIndication);
  toStruct_ConfidenceLevel(in.confidence_level, out.confidenceLevel);
}

}
