/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DF contains information about a perceived object including its kinematic state and attitude vector in a pre-defined coordinate system and with respect to a reference time.
 * 
 * It shall include the following components: 
 *
 * @field objectId: optional identifier assigned to a detected object.
 *
 * @field measurementDeltaTime: the time difference from a reference time to the time of the  measurement of the object. 
 * Negative values indicate that the provided object state refers to a point in time before the reference time.
 *
 * @field position: the position of the geometric centre of the object's bounding box within the pre-defined coordinate system.
 *
 * @field velocity: the velocity vector of the object within the pre-defined coordinate system.
 *
 * @field acceleration: the acceleration vector of the object within the pre-defined coordinate system.
 *
 * @field angles: optional Euler angles of the object bounding box at the time of measurement. 
 * 
 * @field zAngularVelocity: optional angular velocity of the object around the z-axis at the time of measurement.
 * The angular velocity is measured with positive values considering the object orientation turning around the z-axis using the right-hand rule.
 *
 * @field lowerTriangularCorrelationMatrices: optional set of lower triangular correlation matrices for selected components of the provided kinematic state and attitude vector.
 *
 * @field objectDimensionZ: optional z-dimension of object bounding box. 
 * This dimension shall be measured along the direction of the z-axis after all the rotations have been applied. 
 *
 * @field objectDimensionY: optional y-dimension of the object bounding box. 
 * This dimension shall be measured along the direction of the y-axis after all the rotations have been applied. 
 *
 * @field objectDimensionX: optional x-dimension of object bounding box.
 * This dimension shall be measured along the direction of the x-axis after all the rotations have been applied.
 * 
 * @field objectAge: optional age of the detected and described object, i.e. the difference in time between the moment 
 * it has been first detected and the reference time of the message. Value `1500` indicates that the object has been observed for more than 1.5s.
 *
 * @field objectPerceptionQuality: optional confidence associated to the object. 
 *
 * @field sensorIdList: optional list of sensor-IDs which provided the measurement data. 
 *
 * @field classification: optional classification of the described object
 *
 * @field matchedPosition: optional map-matched position of an object.
 *
 * @category Sensing information
 * @revision: created in V2.1.1
 *
PerceivedObject ::= SEQUENCE {
    objectId                                          Identifier2B OPTIONAL,
    measurementDeltaTime                              DeltaTimeMilliSecondSigned,
    position                                          CartesianPosition3dWithConfidence, 
    velocity                                          Velocity3dWithConfidence OPTIONAL,
    acceleration                                      Acceleration3dWithConfidence OPTIONAL,
    angles                                            EulerAnglesWithConfidence OPTIONAL,
    zAngularVelocity                                  CartesianAngularVelocityComponent OPTIONAL,
    lowerTriangularCorrelationMatrices                LowerTriangularPositiveSemidefiniteMatrices OPTIONAL,
    objectDimensionZ                                  ObjectDimension OPTIONAL,
    objectDimensionY                                  ObjectDimension OPTIONAL,
    objectDimensionX                                  ObjectDimension OPTIONAL,
    objectAge                                         DeltaTimeMilliSecondSigned (0..2047) OPTIONAL,
    objectPerceptionQuality                           ObjectPerceptionQuality OPTIONAL,
    sensorIdList                                      SequenceOfIdentifier1B OPTIONAL,
    classification                                    ObjectClassDescription OPTIONAL,
    mapPosition                                       MapPosition OPTIONAL,
    ...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_PerceivedObject.h>
#include <etsi_its_denm_ts_conversion/convertAcceleration3dWithConfidence.h>
#include <etsi_its_denm_ts_conversion/convertCartesianAngularVelocityComponent.h>
#include <etsi_its_denm_ts_conversion/convertCartesianPosition3dWithConfidence.h>
#include <etsi_its_denm_ts_conversion/convertDeltaTimeMilliSecondSigned.h>
#include <etsi_its_denm_ts_conversion/convertEulerAnglesWithConfidence.h>
#include <etsi_its_denm_ts_conversion/convertIdentifier2B.h>
#include <etsi_its_denm_ts_conversion/convertLowerTriangularPositiveSemidefiniteMatrices.h>
#include <etsi_its_denm_ts_conversion/convertMapPosition.h>
#include <etsi_its_denm_ts_conversion/convertObjectClassDescription.h>
#include <etsi_its_denm_ts_conversion/convertObjectDimension.h>
#include <etsi_its_denm_ts_conversion/convertObjectPerceptionQuality.h>
#include <etsi_its_denm_ts_conversion/convertSequenceOfIdentifier1B.h>
#include <etsi_its_denm_ts_conversion/convertVelocity3dWithConfidence.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/PerceivedObject.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/perceived_object.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_PerceivedObject(const denm_ts_PerceivedObject_t& in, denm_ts_msgs::PerceivedObject& out) {
  if (in.objectId) {
    toRos_Identifier2B(*in.objectId, out.object_id);
    out.object_id_is_present = true;
  }
  toRos_DeltaTimeMilliSecondSigned(in.measurementDeltaTime, out.measurement_delta_time);
  toRos_CartesianPosition3dWithConfidence(in.position, out.position);
  if (in.velocity) {
    toRos_Velocity3dWithConfidence(*in.velocity, out.velocity);
    out.velocity_is_present = true;
  }
  if (in.acceleration) {
    toRos_Acceleration3dWithConfidence(*in.acceleration, out.acceleration);
    out.acceleration_is_present = true;
  }
  if (in.angles) {
    toRos_EulerAnglesWithConfidence(*in.angles, out.angles);
    out.angles_is_present = true;
  }
  if (in.zAngularVelocity) {
    toRos_CartesianAngularVelocityComponent(*in.zAngularVelocity, out.z_angular_velocity);
    out.z_angular_velocity_is_present = true;
  }
  if (in.lowerTriangularCorrelationMatrices) {
    toRos_LowerTriangularPositiveSemidefiniteMatrices(*in.lowerTriangularCorrelationMatrices, out.lower_triangular_correlation_matrices);
    out.lower_triangular_correlation_matrices_is_present = true;
  }
  if (in.objectDimensionZ) {
    toRos_ObjectDimension(*in.objectDimensionZ, out.object_dimension_z);
    out.object_dimension_z_is_present = true;
  }
  if (in.objectDimensionY) {
    toRos_ObjectDimension(*in.objectDimensionY, out.object_dimension_y);
    out.object_dimension_y_is_present = true;
  }
  if (in.objectDimensionX) {
    toRos_ObjectDimension(*in.objectDimensionX, out.object_dimension_x);
    out.object_dimension_x_is_present = true;
  }
  if (in.objectAge) {
    toRos_DeltaTimeMilliSecondSigned(*in.objectAge, out.object_age);
    out.object_age_is_present = true;
  }
  if (in.objectPerceptionQuality) {
    toRos_ObjectPerceptionQuality(*in.objectPerceptionQuality, out.object_perception_quality);
    out.object_perception_quality_is_present = true;
  }
  if (in.sensorIdList) {
    toRos_SequenceOfIdentifier1B(*in.sensorIdList, out.sensor_id_list);
    out.sensor_id_list_is_present = true;
  }
  if (in.classification) {
    toRos_ObjectClassDescription(*in.classification, out.classification);
    out.classification_is_present = true;
  }
  if (in.mapPosition) {
    toRos_MapPosition(*in.mapPosition, out.map_position);
    out.map_position_is_present = true;
  }
}

void toStruct_PerceivedObject(const denm_ts_msgs::PerceivedObject& in, denm_ts_PerceivedObject_t& out) {
  memset(&out, 0, sizeof(denm_ts_PerceivedObject_t));
  if (in.object_id_is_present) {
    out.objectId = (denm_ts_Identifier2B_t*) calloc(1, sizeof(denm_ts_Identifier2B_t));
    toStruct_Identifier2B(in.object_id, *out.objectId);
  }
  toStruct_DeltaTimeMilliSecondSigned(in.measurement_delta_time, out.measurementDeltaTime);
  toStruct_CartesianPosition3dWithConfidence(in.position, out.position);
  if (in.velocity_is_present) {
    out.velocity = (denm_ts_Velocity3dWithConfidence_t*) calloc(1, sizeof(denm_ts_Velocity3dWithConfidence_t));
    toStruct_Velocity3dWithConfidence(in.velocity, *out.velocity);
  }
  if (in.acceleration_is_present) {
    out.acceleration = (denm_ts_Acceleration3dWithConfidence_t*) calloc(1, sizeof(denm_ts_Acceleration3dWithConfidence_t));
    toStruct_Acceleration3dWithConfidence(in.acceleration, *out.acceleration);
  }
  if (in.angles_is_present) {
    out.angles = (denm_ts_EulerAnglesWithConfidence_t*) calloc(1, sizeof(denm_ts_EulerAnglesWithConfidence_t));
    toStruct_EulerAnglesWithConfidence(in.angles, *out.angles);
  }
  if (in.z_angular_velocity_is_present) {
    out.zAngularVelocity = (denm_ts_CartesianAngularVelocityComponent_t*) calloc(1, sizeof(denm_ts_CartesianAngularVelocityComponent_t));
    toStruct_CartesianAngularVelocityComponent(in.z_angular_velocity, *out.zAngularVelocity);
  }
  if (in.lower_triangular_correlation_matrices_is_present) {
    out.lowerTriangularCorrelationMatrices = (denm_ts_LowerTriangularPositiveSemidefiniteMatrices_t*) calloc(1, sizeof(denm_ts_LowerTriangularPositiveSemidefiniteMatrices_t));
    toStruct_LowerTriangularPositiveSemidefiniteMatrices(in.lower_triangular_correlation_matrices, *out.lowerTriangularCorrelationMatrices);
  }
  if (in.object_dimension_z_is_present) {
    out.objectDimensionZ = (denm_ts_ObjectDimension_t*) calloc(1, sizeof(denm_ts_ObjectDimension_t));
    toStruct_ObjectDimension(in.object_dimension_z, *out.objectDimensionZ);
  }
  if (in.object_dimension_y_is_present) {
    out.objectDimensionY = (denm_ts_ObjectDimension_t*) calloc(1, sizeof(denm_ts_ObjectDimension_t));
    toStruct_ObjectDimension(in.object_dimension_y, *out.objectDimensionY);
  }
  if (in.object_dimension_x_is_present) {
    out.objectDimensionX = (denm_ts_ObjectDimension_t*) calloc(1, sizeof(denm_ts_ObjectDimension_t));
    toStruct_ObjectDimension(in.object_dimension_x, *out.objectDimensionX);
  }
  if (in.object_age_is_present) {
    out.objectAge = (denm_ts_DeltaTimeMilliSecondSigned_t*) calloc(1, sizeof(denm_ts_DeltaTimeMilliSecondSigned_t));
    toStruct_DeltaTimeMilliSecondSigned(in.object_age, *out.objectAge);
  }
  if (in.object_perception_quality_is_present) {
    out.objectPerceptionQuality = (denm_ts_ObjectPerceptionQuality_t*) calloc(1, sizeof(denm_ts_ObjectPerceptionQuality_t));
    toStruct_ObjectPerceptionQuality(in.object_perception_quality, *out.objectPerceptionQuality);
  }
  if (in.sensor_id_list_is_present) {
    out.sensorIdList = (denm_ts_SequenceOfIdentifier1B_t*) calloc(1, sizeof(denm_ts_SequenceOfIdentifier1B_t));
    toStruct_SequenceOfIdentifier1B(in.sensor_id_list, *out.sensorIdList);
  }
  if (in.classification_is_present) {
    out.classification = (denm_ts_ObjectClassDescription_t*) calloc(1, sizeof(denm_ts_ObjectClassDescription_t));
    toStruct_ObjectClassDescription(in.classification, *out.classification);
  }
  if (in.map_position_is_present) {
    out.mapPosition = (denm_ts_MapPosition_t*) calloc(1, sizeof(denm_ts_MapPosition_t));
    toStruct_MapPosition(in.map_position, *out.mapPosition);
  }
}

}
