/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF indicates the horizontal position confidence ellipse which represents the estimated accuracy with a 
 * confidence level of 95  %. The centre of the ellipse shape corresponds to the reference
 * position point for which the position accuracy is evaluated.
 *
 * It shall include the following components: 
 *
 * @field semiMajorConfidence: half of length of the major axis, i.e. distance between the centre point
 * and major axis point of the position accuracy ellipse. 
 *
 * @field semiMinorConfidence: half of length of the minor axis, i.e. distance between the centre point
 * and minor axis point of the position accuracy ellipse. 
 *
 * @field semiMajorOrientation: orientation direction of the ellipse major axis of the position accuracy
 * ellipse with regards to the WGS84 north. 
 * The specific WGS84 coordinate system is specified by the corresponding standards applying this DE.
 *
 *
 * @category GeoReference information
 * @revision: V1.3.1
 *
PosConfidenceEllipse ::= SEQUENCE {
    semiMajorConfidence     SemiAxisLength,
    semiMinorConfidence     SemiAxisLength,
    semiMajorOrientation    HeadingValue
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_PosConfidenceEllipse.h>
#include <etsi_its_denm_ts_conversion/convertHeadingValue.h>
#include <etsi_its_denm_ts_conversion/convertSemiAxisLength.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/PosConfidenceEllipse.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/pos_confidence_ellipse.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_PosConfidenceEllipse(const denm_ts_PosConfidenceEllipse_t& in, denm_ts_msgs::PosConfidenceEllipse& out) {
  toRos_SemiAxisLength(in.semiMajorConfidence, out.semi_major_confidence);
  toRos_SemiAxisLength(in.semiMinorConfidence, out.semi_minor_confidence);
  toRos_HeadingValue(in.semiMajorOrientation, out.semi_major_orientation);
}

void toStruct_PosConfidenceEllipse(const denm_ts_msgs::PosConfidenceEllipse& in, denm_ts_PosConfidenceEllipse_t& out) {
  memset(&out, 0, sizeof(denm_ts_PosConfidenceEllipse_t));
  toStruct_SemiAxisLength(in.semi_major_confidence, out.semiMajorConfidence);
  toStruct_SemiAxisLength(in.semi_minor_confidence, out.semiMinorConfidence);
  toStruct_HeadingValue(in.semi_major_orientation, out.semiMajorOrientation);
}

}
