/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This type contains detailed information about an object with which a vehicle and/or the traffic is likely to collide.
 *
 * It shall include the following components: 
 *
 * @field perceivedPreCrashObject: information about a perceived object in the East, North, Up reference frame.
 *
 * @field objectStationId: the optional station Id of the object for which the information is provided.
 *
 * @field timeToCollision: the optional estimated time to collision of a vehicle with the object. 
 *
 * @field impactSection: indication of the object's section where the impact will most likely occur. 
 * When the target object is likely to be a vehicle, then this component should be present, otherwise it should not be provided.  
 *
 * @field estimatedBrakingDistance: the optional estimated distance in which the vehicle would need to come to a complete hold, 
 * if no obstruction was in the way. 
*
PreCrashContainer ::= SEQUENCE { 
    perceivedPreCrashObject   PerceivedObject, 
    objectStationId           StationId OPTIONAL, 
    timeToCollision           DeltaTimeMilliSecondPositive OPTIONAL, 
    impactSection             ObjectFace OPTIONAL, 
    estimatedBrakingDistance  StandardLength12b OPTIONAL,
    ... 
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_PreCrashContainer.h>
#include <etsi_its_denm_ts_conversion/convertDeltaTimeMilliSecondPositive.h>
#include <etsi_its_denm_ts_conversion/convertObjectFace.h>
#include <etsi_its_denm_ts_conversion/convertPerceivedObject.h>
#include <etsi_its_denm_ts_conversion/convertStandardLength12b.h>
#include <etsi_its_denm_ts_conversion/convertStationId.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/PreCrashContainer.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/pre_crash_container.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_PreCrashContainer(const denm_ts_PreCrashContainer_t& in, denm_ts_msgs::PreCrashContainer& out) {
  toRos_PerceivedObject(in.perceivedPreCrashObject, out.perceived_pre_crash_object);
  if (in.objectStationId) {
    toRos_StationId(*in.objectStationId, out.object_station_id);
    out.object_station_id_is_present = true;
  }
  if (in.timeToCollision) {
    toRos_DeltaTimeMilliSecondPositive(*in.timeToCollision, out.time_to_collision);
    out.time_to_collision_is_present = true;
  }
  if (in.impactSection) {
    toRos_ObjectFace(*in.impactSection, out.impact_section);
    out.impact_section_is_present = true;
  }
  if (in.estimatedBrakingDistance) {
    toRos_StandardLength12b(*in.estimatedBrakingDistance, out.estimated_braking_distance);
    out.estimated_braking_distance_is_present = true;
  }
}

void toStruct_PreCrashContainer(const denm_ts_msgs::PreCrashContainer& in, denm_ts_PreCrashContainer_t& out) {
  memset(&out, 0, sizeof(denm_ts_PreCrashContainer_t));
  toStruct_PerceivedObject(in.perceived_pre_crash_object, out.perceivedPreCrashObject);
  if (in.object_station_id_is_present) {
    out.objectStationId = (denm_ts_StationId_t*) calloc(1, sizeof(denm_ts_StationId_t));
    toStruct_StationId(in.object_station_id, *out.objectStationId);
  }
  if (in.time_to_collision_is_present) {
    out.timeToCollision = (denm_ts_DeltaTimeMilliSecondPositive_t*) calloc(1, sizeof(denm_ts_DeltaTimeMilliSecondPositive_t));
    toStruct_DeltaTimeMilliSecondPositive(in.time_to_collision, *out.timeToCollision);
  }
  if (in.impact_section_is_present) {
    out.impactSection = (denm_ts_ObjectFace_t*) calloc(1, sizeof(denm_ts_ObjectFace_t));
    toStruct_ObjectFace(in.impact_section, *out.impactSection);
  }
  if (in.estimated_braking_distance_is_present) {
    out.estimatedBrakingDistance = (denm_ts_StandardLength12b_t*) calloc(1, sizeof(denm_ts_StandardLength12b_t));
    toStruct_StandardLength12b(in.estimated_braking_distance, *out.estimatedBrakingDistance);
  }
}

}
