/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF identifies an organization.
 *
 * It shall include the following components: 
 * 
 * @field countryCode: represents the country code that identifies the country of the national registration administrator for issuers according to ISO 14816.
 *
 * @field providerIdentifier: identifies the organization according to the national ISO 14816 register for issuers.
 *
 * @note: See https://www.itsstandards.eu/registries/register-of-nra-i-cs1/ for a list of national registration administrators and their respective registers
 * 
 * @category: Communication information
 * @revision: Created in V2.2.1 based on ISO 17573-3 [24]
 *
Provider ::= SEQUENCE {
	countryCode		CountryCode,
	providerIdentifier	IssuerIdentifier
} 
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_Provider.h>
#include <etsi_its_denm_ts_conversion/convertCountryCode.h>
#include <etsi_its_denm_ts_conversion/convertIssuerIdentifier.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/Provider.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/provider.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_Provider(const denm_ts_Provider_t& in, denm_ts_msgs::Provider& out) {
  toRos_CountryCode(in.countryCode, out.country_code);
  toRos_IssuerIdentifier(in.providerIdentifier, out.provider_identifier);
}

void toStruct_Provider(const denm_ts_msgs::Provider& in, denm_ts_Provider_t& out) {
  memset(&out, 0, sizeof(denm_ts_Provider_t));
  toStruct_CountryCode(in.country_code, out.countryCode);
  toStruct_IssuerIdentifier(in.provider_identifier, out.providerIdentifier);
}

}
