/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF describes radial shape details. The circular sector or cone is
 * constructed by sweeping the provided range about the position specified outside of the  
 * context of this DF. The range is swept between a horizontal start and a horizontal end angle in 
 * the X-Y plane of a right-hand cartesian coordinate system specified outside of the context of 
 * this DF, in positive angular direction w.r.t. the x-axis. A vertical opening angle in the X-Z 
 * plane may optionally be provided in positive angular direction w.r.t. the x-axis.
 * 
 * It shall include the following components:
 * 
 * @field range: the radial range of the sensor from the reference point or sensor point offset. 
 *
 * @field horizontalOpeningAngleStart:  the start of the shape's horizontal opening angle.
 *
 * @field horizontalOpeningAngleEnd: the end of the shape's horizontal opening angle. 
 *
 * @field verticalOpeningAngleStart: optional start of the shape's vertical opening angle. 
 *
 * @field verticalOpeningAngleEnd: optional end of the shape's vertical opening angle. 
 *
 * @category: Georeference information
 * @revision: created in V2.1.1, description revised and constraint added in V2.2.1
 *
RadialShapeDetails ::= SEQUENCE {
    range                          StandardLength12b,
    horizontalOpeningAngleStart    CartesianAngleValue,
    horizontalOpeningAngleEnd      CartesianAngleValue,
    verticalOpeningAngleStart      CartesianAngleValue OPTIONAL,
    verticalOpeningAngleEnd        CartesianAngleValue OPTIONAL
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_RadialShapeDetails.h>
#include <etsi_its_denm_ts_conversion/convertCartesianAngleValue.h>
#include <etsi_its_denm_ts_conversion/convertStandardLength12b.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/RadialShapeDetails.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/radial_shape_details.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_RadialShapeDetails(const denm_ts_RadialShapeDetails_t& in, denm_ts_msgs::RadialShapeDetails& out) {
  toRos_StandardLength12b(in.range, out.range);
  toRos_CartesianAngleValue(in.horizontalOpeningAngleStart, out.horizontal_opening_angle_start);
  toRos_CartesianAngleValue(in.horizontalOpeningAngleEnd, out.horizontal_opening_angle_end);
  if (in.verticalOpeningAngleStart) {
    toRos_CartesianAngleValue(*in.verticalOpeningAngleStart, out.vertical_opening_angle_start);
    out.vertical_opening_angle_start_is_present = true;
  }
  if (in.verticalOpeningAngleEnd) {
    toRos_CartesianAngleValue(*in.verticalOpeningAngleEnd, out.vertical_opening_angle_end);
    out.vertical_opening_angle_end_is_present = true;
  }
}

void toStruct_RadialShapeDetails(const denm_ts_msgs::RadialShapeDetails& in, denm_ts_RadialShapeDetails_t& out) {
  memset(&out, 0, sizeof(denm_ts_RadialShapeDetails_t));
  toStruct_StandardLength12b(in.range, out.range);
  toStruct_CartesianAngleValue(in.horizontal_opening_angle_start, out.horizontalOpeningAngleStart);
  toStruct_CartesianAngleValue(in.horizontal_opening_angle_end, out.horizontalOpeningAngleEnd);
  if (in.vertical_opening_angle_start_is_present) {
    out.verticalOpeningAngleStart = (denm_ts_CartesianAngleValue_t*) calloc(1, sizeof(denm_ts_CartesianAngleValue_t));
    toStruct_CartesianAngleValue(in.vertical_opening_angle_start, *out.verticalOpeningAngleStart);
  }
  if (in.vertical_opening_angle_end_is_present) {
    out.verticalOpeningAngleEnd = (denm_ts_CartesianAngleValue_t*) calloc(1, sizeof(denm_ts_CartesianAngleValue_t));
    toStruct_CartesianAngleValue(in.vertical_opening_angle_end, *out.verticalOpeningAngleEnd);
  }
}

}
