/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF describes a list of radial shapes positioned w.r.t. to an offset position defined  
 * relative to a reference position specified outside of the context of this DF and oriented w.r.t.  
 * a cartesian coordinate system specified outside of the context of this DF. 
 *
 * It shall include the following components:
 *
 * @field refPointId: the identification of the reference point in case of a sensor mounted to trailer. Defaults to ITS ReferencePoint (0).
 * 
 * @field xCoordinate: the x-coordinate of the offset position.
 *
 * @field yCoordinate: the y-coordinate of the offset position.
 *
 * @field zCoordinate: the optional z-coordinate of the offset position.
 *
 * @field radialShapesList: the list of radial shape details.
 *
 * @category: Georeference information
 * @revision: created in V2.1.1, description revised in V2.2.1
 * 
RadialShapes ::= SEQUENCE {
    refPointId          Identifier1B,
    xCoordinate         CartesianCoordinateSmall, 
    yCoordinate         CartesianCoordinateSmall,
    zCoordinate         CartesianCoordinateSmall OPTIONAL,
    radialShapesList    RadialShapesList
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_RadialShapes.h>
#include <etsi_its_denm_ts_conversion/convertCartesianCoordinateSmall.h>
#include <etsi_its_denm_ts_conversion/convertIdentifier1B.h>
#include <etsi_its_denm_ts_conversion/convertRadialShapesList.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/RadialShapes.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/radial_shapes.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_RadialShapes(const denm_ts_RadialShapes_t& in, denm_ts_msgs::RadialShapes& out) {
  toRos_Identifier1B(in.refPointId, out.ref_point_id);
  toRos_CartesianCoordinateSmall(in.xCoordinate, out.x_coordinate);
  toRos_CartesianCoordinateSmall(in.yCoordinate, out.y_coordinate);
  if (in.zCoordinate) {
    toRos_CartesianCoordinateSmall(*in.zCoordinate, out.z_coordinate);
    out.z_coordinate_is_present = true;
  }
  toRos_RadialShapesList(in.radialShapesList, out.radial_shapes_list);
}

void toStruct_RadialShapes(const denm_ts_msgs::RadialShapes& in, denm_ts_RadialShapes_t& out) {
  memset(&out, 0, sizeof(denm_ts_RadialShapes_t));
  toStruct_Identifier1B(in.ref_point_id, out.refPointId);
  toStruct_CartesianCoordinateSmall(in.x_coordinate, out.xCoordinate);
  toStruct_CartesianCoordinateSmall(in.y_coordinate, out.yCoordinate);
  if (in.z_coordinate_is_present) {
    out.zCoordinate = (denm_ts_CartesianCoordinateSmall_t*) calloc(1, sizeof(denm_ts_CartesianCoordinateSmall_t));
    toStruct_CartesianCoordinateSmall(in.z_coordinate, *out.zCoordinate);
  }
  toStruct_RadialShapesList(in.radial_shapes_list, out.radialShapesList);
}

}
