/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DF provides configuration information about a road section.
 *
 * It shall include the following components: 
 *
 * @field roadSectionDefinition: the topological definition of the road section for which the information in the other components applies throughout its entire length.
 * 
 * @field roadType: the optional type of road on which the section is located.
 * 
 * @field laneConfiguration: the optional configuration of the road section in terms of basic information per lane.
 *
 * @field mapemConfiguration: the optional configuration of the road section in terms of MAPEM lanes or connections.
 *
 * @category: Road topology information
 * @revision: Created in V2.2.1
*
RoadConfigurationSection ::= SEQUENCE {
  roadSectionDefinition  RoadSectionDefinition,
  roadType               RoadType OPTIONAL, 
  laneConfiguration      BasicLaneConfiguration OPTIONAL,
  mapemConfiguration     MapemConfiguration OPTIONAL,
  ...
} 
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_RoadConfigurationSection.h>
#include <etsi_its_denm_ts_conversion/convertBasicLaneConfiguration.h>
#include <etsi_its_denm_ts_conversion/convertMapemConfiguration.h>
#include <etsi_its_denm_ts_conversion/convertRoadSectionDefinition.h>
#include <etsi_its_denm_ts_conversion/convertRoadType.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/RoadConfigurationSection.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/road_configuration_section.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_RoadConfigurationSection(const denm_ts_RoadConfigurationSection_t& in, denm_ts_msgs::RoadConfigurationSection& out) {
  toRos_RoadSectionDefinition(in.roadSectionDefinition, out.road_section_definition);
  if (in.roadType) {
    toRos_RoadType(*in.roadType, out.road_type);
    out.road_type_is_present = true;
  }
  if (in.laneConfiguration) {
    toRos_BasicLaneConfiguration(*in.laneConfiguration, out.lane_configuration);
    out.lane_configuration_is_present = true;
  }
  if (in.mapemConfiguration) {
    toRos_MapemConfiguration(*in.mapemConfiguration, out.mapem_configuration);
    out.mapem_configuration_is_present = true;
  }
}

void toStruct_RoadConfigurationSection(const denm_ts_msgs::RoadConfigurationSection& in, denm_ts_RoadConfigurationSection_t& out) {
  memset(&out, 0, sizeof(denm_ts_RoadConfigurationSection_t));
  toStruct_RoadSectionDefinition(in.road_section_definition, out.roadSectionDefinition);
  if (in.road_type_is_present) {
    out.roadType = (denm_ts_RoadType_t*) calloc(1, sizeof(denm_ts_RoadType_t));
    toStruct_RoadType(in.road_type, *out.roadType);
  }
  if (in.lane_configuration_is_present) {
    out.laneConfiguration = (denm_ts_BasicLaneConfiguration_t*) calloc(1, sizeof(denm_ts_BasicLaneConfiguration_t));
    toStruct_BasicLaneConfiguration(in.lane_configuration, *out.laneConfiguration);
  }
  if (in.mapem_configuration_is_present) {
    out.mapemConfiguration = (denm_ts_MapemConfiguration_t*) calloc(1, sizeof(denm_ts_MapemConfiguration_t));
    toStruct_MapemConfiguration(in.mapem_configuration, *out.mapemConfiguration);
  }
}

}
