/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This type contains detailed information of a roadwork zone and specific access conditions.
 *
 * It shall include the following components: 
 *
 * @field lightBarSirenInUse: optionally indicates whether a roadwork vehicle has switched on the light bar or siren. 
 * It is used when the roadwork involves a specific roadwork vehicle
 *
 * @field closedLanes: optionally indicates whether the roadwork has caused the closure of one or several driving lanes. 
 * Optionally, it may indicate whether a hard shoulder lane is closed to traffic or can be used for specific usage (e.g. for stopping).
 *
 * @field restriction: the optional type(s) of vehicles that are restricted to access the road work zone. 
 * More than one vehicle types may be provided by this component if the restriction apply to multiple vehicle types. 
 *
 * @field speedLimit: the optional speed limitation applied to the roadwork zone.
 *
 * @field incidentIndication: the optional incident related to the roadworks to provide additional information of the roadworks zone.
 *
 * @field recommendedPath: the optional recommended itinerary in order to contour the roadworks zone. If present, a recommended path 
 * shall be a list of path points in the order from the starting point closest to the roadworks zone to the end point of the recommended path. 
 *
 * @field startingPointSpeedLimit: the optional effective starting position of a speed limit being applied to the roadwork zone, 
 * with respect to the component eventPosition on the Management Container.
 * This component shall be present if the speed limit is applied at a certain distance prior to the roadwork zone starting position.
 *
 * @field trafficFlowRule: optionally indicates the side of the road to which the traffic should flow around a roadwork.
 *
 * @field referenceDenms: an optional sequence of actionIds for different DENMs that describe the same event. 
 * If it is available, it indicates the actionIds of all other DENMs describing this event.
 *
*
RoadWorksContainerExtended ::= SEQUENCE {
    lightBarSirenInUse      LightBarSirenInUse OPTIONAL,
    closedLanes             ClosedLanes OPTIONAL,
    restriction             RestrictedTypes OPTIONAL,
    speedLimit              SpeedLimit OPTIONAL,
    incidentIndication      CauseCodeV2 OPTIONAL,
    recommendedPath         ItineraryPath OPTIONAL,
    startingPointSpeedLimit DeltaReferencePosition OPTIONAL,
    trafficFlowRule         TrafficRule OPTIONAL,
    referenceDenms          ActionIdList OPTIONAL
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_RoadWorksContainerExtended.h>
#include <etsi_its_denm_ts_conversion/convertActionIdList.h>
#include <etsi_its_denm_ts_conversion/convertCauseCodeV2.h>
#include <etsi_its_denm_ts_conversion/convertClosedLanes.h>
#include <etsi_its_denm_ts_conversion/convertDeltaReferencePosition.h>
#include <etsi_its_denm_ts_conversion/convertItineraryPath.h>
#include <etsi_its_denm_ts_conversion/convertLightBarSirenInUse.h>
#include <etsi_its_denm_ts_conversion/convertRestrictedTypes.h>
#include <etsi_its_denm_ts_conversion/convertSpeedLimit.h>
#include <etsi_its_denm_ts_conversion/convertTrafficRule.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/RoadWorksContainerExtended.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/road_works_container_extended.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_RoadWorksContainerExtended(const denm_ts_RoadWorksContainerExtended_t& in, denm_ts_msgs::RoadWorksContainerExtended& out) {
  if (in.lightBarSirenInUse) {
    toRos_LightBarSirenInUse(*in.lightBarSirenInUse, out.light_bar_siren_in_use);
    out.light_bar_siren_in_use_is_present = true;
  }
  if (in.closedLanes) {
    toRos_ClosedLanes(*in.closedLanes, out.closed_lanes);
    out.closed_lanes_is_present = true;
  }
  if (in.restriction) {
    toRos_RestrictedTypes(*in.restriction, out.restriction);
    out.restriction_is_present = true;
  }
  if (in.speedLimit) {
    toRos_SpeedLimit(*in.speedLimit, out.speed_limit);
    out.speed_limit_is_present = true;
  }
  if (in.incidentIndication) {
    toRos_CauseCodeV2(*in.incidentIndication, out.incident_indication);
    out.incident_indication_is_present = true;
  }
  if (in.recommendedPath) {
    toRos_ItineraryPath(*in.recommendedPath, out.recommended_path);
    out.recommended_path_is_present = true;
  }
  if (in.startingPointSpeedLimit) {
    toRos_DeltaReferencePosition(*in.startingPointSpeedLimit, out.starting_point_speed_limit);
    out.starting_point_speed_limit_is_present = true;
  }
  if (in.trafficFlowRule) {
    toRos_TrafficRule(*in.trafficFlowRule, out.traffic_flow_rule);
    out.traffic_flow_rule_is_present = true;
  }
  if (in.referenceDenms) {
    toRos_ActionIdList(*in.referenceDenms, out.reference_denms);
    out.reference_denms_is_present = true;
  }
}

void toStruct_RoadWorksContainerExtended(const denm_ts_msgs::RoadWorksContainerExtended& in, denm_ts_RoadWorksContainerExtended_t& out) {
  memset(&out, 0, sizeof(denm_ts_RoadWorksContainerExtended_t));
  if (in.light_bar_siren_in_use_is_present) {
    out.lightBarSirenInUse = (denm_ts_LightBarSirenInUse_t*) calloc(1, sizeof(denm_ts_LightBarSirenInUse_t));
    toStruct_LightBarSirenInUse(in.light_bar_siren_in_use, *out.lightBarSirenInUse);
  }
  if (in.closed_lanes_is_present) {
    out.closedLanes = (denm_ts_ClosedLanes_t*) calloc(1, sizeof(denm_ts_ClosedLanes_t));
    toStruct_ClosedLanes(in.closed_lanes, *out.closedLanes);
  }
  if (in.restriction_is_present) {
    out.restriction = (denm_ts_RestrictedTypes_t*) calloc(1, sizeof(denm_ts_RestrictedTypes_t));
    toStruct_RestrictedTypes(in.restriction, *out.restriction);
  }
  if (in.speed_limit_is_present) {
    out.speedLimit = (denm_ts_SpeedLimit_t*) calloc(1, sizeof(denm_ts_SpeedLimit_t));
    toStruct_SpeedLimit(in.speed_limit, *out.speedLimit);
  }
  if (in.incident_indication_is_present) {
    out.incidentIndication = (denm_ts_CauseCodeV2_t*) calloc(1, sizeof(denm_ts_CauseCodeV2_t));
    toStruct_CauseCodeV2(in.incident_indication, *out.incidentIndication);
  }
  if (in.recommended_path_is_present) {
    out.recommendedPath = (denm_ts_ItineraryPath_t*) calloc(1, sizeof(denm_ts_ItineraryPath_t));
    toStruct_ItineraryPath(in.recommended_path, *out.recommendedPath);
  }
  if (in.starting_point_speed_limit_is_present) {
    out.startingPointSpeedLimit = (denm_ts_DeltaReferencePosition_t*) calloc(1, sizeof(denm_ts_DeltaReferencePosition_t));
    toStruct_DeltaReferencePosition(in.starting_point_speed_limit, *out.startingPointSpeedLimit);
  }
  if (in.traffic_flow_rule_is_present) {
    out.trafficFlowRule = (denm_ts_TrafficRule_t*) calloc(1, sizeof(denm_ts_TrafficRule_t));
    toStruct_TrafficRule(in.traffic_flow_rule, *out.trafficFlowRule);
  }
  if (in.reference_denms_is_present) {
    out.referenceDenms = (denm_ts_ActionIdList_t*) calloc(1, sizeof(denm_ts_ActionIdList_t));
    toStruct_ActionIdList(in.reference_denms, *out.referenceDenms);
  }
}

}
