/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This DE indicates the type of sensor(s).
 * The corresponding bit shall be set to 1 under the following conditions:
 * 
 * - 0  `undefined`         - in case the sensor type is undefined. 
 * - 1  `radar`             - in case the sensor is a radar,
 * - 2  `lidar`             - in case the sensor is a lidar,
 * - 3  `monovideo`         - in case the sensor is mono video,
 * - 4  `stereovision`      - in case the sensor is stereo vision,
 * - 5  `nightvision`       - in case the sensor is night vision,
 * - 6  `ultrasonic`        - in case the sensor is ultrasonic,
 * - 7  `pmd`               - in case the sensor is photonic mixing device,
 * - 8  `inductionLoop`     - in case the sensor is an induction loop,
 * - 9  `sphericalCamera`   - in case the sensor is a spherical camera,
 * - 10 `uwb`               - in case the sensor is ultra wide band,
 * - 11 `acoustic`          - in case the sensor is acoustic,
 * - 12 `localAggregation`  - in case the information is provided by a system that aggregates information from different local sensors. Aggregation may include fusion,
 * - 13 `itsAggregation`    - in case the information is provided by a system that aggregates information from other received ITS messages.
 * - 14-15                  - are reserved for future usage.
 * 
 * @note: If all bits are set to 0, then no sensor type is used
 *
 * @category: Sensing Information
 * @revision: created in V2.2.1
*
SensorTypes ::= BIT STRING {
    undefined         (0),
    radar             (1),
    lidar             (2),
    monovideo         (3),
    stereovision      (4),
    nightvision       (5),
    ultrasonic        (6),
    pmd               (7),
    inductionLoop     (8),
    sphericalCamera   (9),
    uwb               (10),
    acoustic          (11),
    localAggregation  (12),
    itsAggregation    (13)
} (SIZE (16,... ))
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_SensorTypes.h>
#include <etsi_its_denm_ts_coding/BIT_STRING.h>
#include <etsi_its_primitives_conversion/convertBIT_STRING.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/SensorTypes.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/sensor_types.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_SensorTypes(const denm_ts_SensorTypes_t& in, denm_ts_msgs::SensorTypes& out) {
  etsi_its_primitives_conversion::toRos_BIT_STRING(in, out.value);
  out.bits_unused = in.bits_unused;
}

void toStruct_SensorTypes(const denm_ts_msgs::SensorTypes& in, denm_ts_SensorTypes_t& out) {
  memset(&out, 0, sizeof(denm_ts_SensorTypes_t));
  etsi_its_primitives_conversion::toStruct_BIT_STRING(in.value, out);
  out.bits_unused = in.bits_unused;
}

}
