/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This type represents the situation container.
 *
 * It shall include the following components: 
 *
 * @field informationQuality: the quality level of the information provided by the ITS-S application of the originating ITS-S. 
 * It indicates the probability of the detected event being truly existent at the event position.
 *
 * @field eventType: the event type, including direct cause and sub cause.
 *
 * @field linkedCause: the optional type of a linked event co-existing at the same time and the same place (same event zone), 
 * including direct cause and sub cause of the linked event, for which no other DENM is sent out.
 *
 * @field eventZone: an optional list of EventPoint, using the position indicated in the component eventPosition of the Management container 
 * as the reference position for the first EventPoint.
 *
 * @field linkedDenms: the optional list of DF ActionId, pointing to DENMs that are semantically connected because applying to consecutive 
 * event zones at the same time.
 *
 * @field eventEnd: the end position of the event along the road that is affected by the event w.r.t. the component eventPosition of the 
 * Management container. This end position is represented by the length of the event along the road. 
 *
*
SituationContainer ::= SEQUENCE {
    informationQuality InformationQuality,
    eventType          CauseCodeV2,
    linkedCause        CauseCodeV2 OPTIONAL,
    eventZone          EventZone OPTIONAL,
    ...,
[[  linkedDenms        ActionIdList OPTIONAL,
    eventEnd           Position1d OPTIONAL ]]   
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_SituationContainer.h>
#include <etsi_its_denm_ts_conversion/convertActionIdList.h>
#include <etsi_its_denm_ts_conversion/convertCauseCodeV2.h>
#include <etsi_its_denm_ts_conversion/convertEventZone.h>
#include <etsi_its_denm_ts_conversion/convertInformationQuality.h>
#include <etsi_its_denm_ts_conversion/convertPosition1d.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/SituationContainer.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/situation_container.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_SituationContainer(const denm_ts_SituationContainer_t& in, denm_ts_msgs::SituationContainer& out) {
  toRos_InformationQuality(in.informationQuality, out.information_quality);
  toRos_CauseCodeV2(in.eventType, out.event_type);
  if (in.linkedCause) {
    toRos_CauseCodeV2(*in.linkedCause, out.linked_cause);
    out.linked_cause_is_present = true;
  }
  if (in.eventZone) {
    toRos_EventZone(*in.eventZone, out.event_zone);
    out.event_zone_is_present = true;
  }
  if (in.ext1->linkedDenms) {
    toRos_ActionIdList(*in.ext1->linkedDenms, out.linked_denms);
    out.linked_denms_is_present = true;
  }
  if (in.ext1->eventEnd) {
    toRos_Position1d(*in.ext1->eventEnd, out.event_end);
    out.event_end_is_present = true;
  }
}

void toStruct_SituationContainer(const denm_ts_msgs::SituationContainer& in, denm_ts_SituationContainer_t& out) {
  memset(&out, 0, sizeof(denm_ts_SituationContainer_t));
  toStruct_InformationQuality(in.information_quality, out.informationQuality);
  toStruct_CauseCodeV2(in.event_type, out.eventType);
  if (in.linked_cause_is_present) {
    out.linkedCause = (denm_ts_CauseCodeV2_t*) calloc(1, sizeof(denm_ts_CauseCodeV2_t));
    toStruct_CauseCodeV2(in.linked_cause, *out.linkedCause);
  }
  if (in.event_zone_is_present) {
    out.eventZone = (denm_ts_EventZone_t*) calloc(1, sizeof(denm_ts_EventZone_t));
    toStruct_EventZone(in.event_zone, *out.eventZone);
  }
  if (in.linked_denms_is_present) {
    out.ext1->linkedDenms = (denm_ts_ActionIdList_t*) calloc(1, sizeof(denm_ts_ActionIdList_t));
    toStruct_ActionIdList(in.linked_denms, *out.ext1->linkedDenms);
  }
  if (in.event_end_is_present) {
    out.ext1->eventEnd = (denm_ts_Position1d_t*) calloc(1, sizeof(denm_ts_Position1d_t));
    toStruct_Position1d(in.event_end, *out.ext1->eventEnd);
  }
}

}
