/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DE represents the sub cause codes of the @ref CauseCode "slowVehicle".
 * 
 * The value shall be set to:
 * - 0 `unavailable`                    - in case further detailed information on slow vehicle driving event is
 *                                        unavailable,
 * - 1 `maintenanceVehicle`             - in case of a slow driving maintenance vehicle on the road,
 * - 2 `vehiclesSlowingToLookAtAccident`- in case vehicle is temporally slowing down to look at accident, spot, etc.,
 * - 3 `abnormalLoad`                   - in case an abnormal loaded vehicle is driving slowly on the road,
 * - 4 `abnormalWideLoad`               - in case an abnormal wide load vehicle is driving slowly on the road,
 * - 5 `convoy`                         - in case of slow driving convoy on the road,
 * - 6 `snowplough`                     - in case of slow driving snow plough on the road,
 * - 7 `deicing`                        - in case of slow driving de-icing vehicle on the road,
 * - 8 `saltingVehicles`                - in case of slow driving salting vehicle on the road.
 * - 9-255                              - are reserved for future usage.
 * 
 * @category: Traffic information
 * @revision: V1.3.1
 *
SlowVehicleSubCauseCode ::= INTEGER {
    unavailable                     (0), 
    maintenanceVehicle              (1), 
    vehiclesSlowingToLookAtAccident (2), 
    abnormalLoad                    (3), 
    abnormalWideLoad                (4), 
    convoy                          (5), 
    snowplough                      (6), 
    deicing                         (7), 
    saltingVehicles                 (8)
} (0..255)
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_SlowVehicleSubCauseCode.h>
#include <etsi_its_denm_ts_coding/INTEGER.h>
#include <etsi_its_primitives_conversion/convertINTEGER.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/SlowVehicleSubCauseCode.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/slow_vehicle_sub_cause_code.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_SlowVehicleSubCauseCode(const denm_ts_SlowVehicleSubCauseCode_t& in, denm_ts_msgs::SlowVehicleSubCauseCode& out) {
  etsi_its_primitives_conversion::toRos_INTEGER(in, out.value);
}

void toStruct_SlowVehicleSubCauseCode(const denm_ts_msgs::SlowVehicleSubCauseCode& in, denm_ts_SlowVehicleSubCauseCode_t& out) {
  memset(&out, 0, sizeof(denm_ts_SlowVehicleSubCauseCode_t));
  etsi_its_primitives_conversion::toStruct_INTEGER(in.value, out);
}

}
