/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
* 
 * This type contains detailed information about a stationary vehicle.
 *
 * It shall include the following components: 
 *
 * @field stationarySince: the optional time duration of the stationary vehicle being stationary.
 *
 * @field stationaryCause: optional additional information to describe causes of the stationary vehicle event such as human problem.
 *
 * @field carryingDangerousGoods: optional information on the type of dangerous goods, the required emergency action and other information.
 *
 * @field numberOfOccupants: the optional estimated number of occupants involved in the stationary vehicle event.
 *
 * @field vehicleIdentification: the optional identification of the stationary vehicle.
 *
 * @field energyStorageType: the optional vehicle energy storage type information of the stationary vehicle, such as electric, diesel, etc.
 *
*
StationaryVehicleContainer ::= SEQUENCE {
    stationarySince        StationarySince OPTIONAL, 
    stationaryCause        CauseCodeV2 OPTIONAL,
    carryingDangerousGoods DangerousGoodsExtended OPTIONAL,
    numberOfOccupants      NumberOfOccupants OPTIONAL,
    vehicleIdentification  VehicleIdentification OPTIONAL,
    energyStorageType      EnergyStorageType OPTIONAL
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_StationaryVehicleContainer.h>
#include <etsi_its_denm_ts_conversion/convertCauseCodeV2.h>
#include <etsi_its_denm_ts_conversion/convertDangerousGoodsExtended.h>
#include <etsi_its_denm_ts_conversion/convertEnergyStorageType.h>
#include <etsi_its_denm_ts_conversion/convertNumberOfOccupants.h>
#include <etsi_its_denm_ts_conversion/convertStationarySince.h>
#include <etsi_its_denm_ts_conversion/convertVehicleIdentification.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/StationaryVehicleContainer.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/stationary_vehicle_container.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_StationaryVehicleContainer(const denm_ts_StationaryVehicleContainer_t& in, denm_ts_msgs::StationaryVehicleContainer& out) {
  if (in.stationarySince) {
    toRos_StationarySince(*in.stationarySince, out.stationary_since);
    out.stationary_since_is_present = true;
  }
  if (in.stationaryCause) {
    toRos_CauseCodeV2(*in.stationaryCause, out.stationary_cause);
    out.stationary_cause_is_present = true;
  }
  if (in.carryingDangerousGoods) {
    toRos_DangerousGoodsExtended(*in.carryingDangerousGoods, out.carrying_dangerous_goods);
    out.carrying_dangerous_goods_is_present = true;
  }
  if (in.numberOfOccupants) {
    toRos_NumberOfOccupants(*in.numberOfOccupants, out.number_of_occupants);
    out.number_of_occupants_is_present = true;
  }
  if (in.vehicleIdentification) {
    toRos_VehicleIdentification(*in.vehicleIdentification, out.vehicle_identification);
    out.vehicle_identification_is_present = true;
  }
  if (in.energyStorageType) {
    toRos_EnergyStorageType(*in.energyStorageType, out.energy_storage_type);
    out.energy_storage_type_is_present = true;
  }
}

void toStruct_StationaryVehicleContainer(const denm_ts_msgs::StationaryVehicleContainer& in, denm_ts_StationaryVehicleContainer_t& out) {
  memset(&out, 0, sizeof(denm_ts_StationaryVehicleContainer_t));
  if (in.stationary_since_is_present) {
    out.stationarySince = (denm_ts_StationarySince_t*) calloc(1, sizeof(denm_ts_StationarySince_t));
    toStruct_StationarySince(in.stationary_since, *out.stationarySince);
  }
  if (in.stationary_cause_is_present) {
    out.stationaryCause = (denm_ts_CauseCodeV2_t*) calloc(1, sizeof(denm_ts_CauseCodeV2_t));
    toStruct_CauseCodeV2(in.stationary_cause, *out.stationaryCause);
  }
  if (in.carrying_dangerous_goods_is_present) {
    out.carryingDangerousGoods = (denm_ts_DangerousGoodsExtended_t*) calloc(1, sizeof(denm_ts_DangerousGoodsExtended_t));
    toStruct_DangerousGoodsExtended(in.carrying_dangerous_goods, *out.carryingDangerousGoods);
  }
  if (in.number_of_occupants_is_present) {
    out.numberOfOccupants = (denm_ts_NumberOfOccupants_t*) calloc(1, sizeof(denm_ts_NumberOfOccupants_t));
    toStruct_NumberOfOccupants(in.number_of_occupants, *out.numberOfOccupants);
  }
  if (in.vehicle_identification_is_present) {
    out.vehicleIdentification = (denm_ts_VehicleIdentification_t*) calloc(1, sizeof(denm_ts_VehicleIdentification_t));
    toStruct_VehicleIdentification(in.vehicle_identification, *out.vehicleIdentification);
  }
  if (in.energy_storage_type_is_present) {
    out.energyStorageType = (denm_ts_EnergyStorageType_t*) calloc(1, sizeof(denm_ts_EnergyStorageType_t));
    toStruct_EnergyStorageType(in.energy_storage_type, *out.energyStorageType);
  }
}

}
